/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.jspecify.annotations.Nullable;

public class BlockRespawnAnchor
extends Block {
    public static final MapCodec<BlockRespawnAnchor> a = BlockRespawnAnchor.b(BlockRespawnAnchor::new);
    public static final int b = 0;
    public static final int c = 4;
    public static final BlockStateInteger d = BlockProperties.bd;
    private static final ImmutableList<BaseBlockPosition> e = ImmutableList.of((Object)new BaseBlockPosition(0, 0, -1), (Object)new BaseBlockPosition(-1, 0, 0), (Object)new BaseBlockPosition(0, 0, 1), (Object)new BaseBlockPosition(1, 0, 0), (Object)new BaseBlockPosition(-1, 0, -1), (Object)new BaseBlockPosition(1, 0, -1), (Object)new BaseBlockPosition(-1, 0, 1), (Object)new BaseBlockPosition(1, 0, 1));
    private static final ImmutableList<BaseBlockPosition> f = new ImmutableList.Builder().addAll(e).addAll(e.stream().map(BaseBlockPosition::p).iterator()).addAll(e.stream().map(BaseBlockPosition::q).iterator()).add((Object)new BaseBlockPosition(0, 1, 0)).build();

    public MapCodec<BlockRespawnAnchor> a() {
        return a;
    }

    public BlockRespawnAnchor(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.l((IBlockData)((IBlockData)this.C.b()).b(d, 0));
    }

    @Override
    protected EnumInteractionResult a(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        if (BlockRespawnAnchor.a(itemstack) && BlockRespawnAnchor.p(iblockdata)) {
            BlockRespawnAnchor.a(entityhuman, world, blockposition, iblockdata);
            itemstack.a(1, (EntityLiving)entityhuman);
            return EnumInteractionResult.a;
        }
        return (EnumInteractionResult)((Object)(enumhand == EnumHand.a && BlockRespawnAnchor.a(entityhuman.b(EnumHand.b)) && BlockRespawnAnchor.p(iblockdata) ? EnumInteractionResult.e : EnumInteractionResult.f));
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (iblockdata.c(d) == 0) {
            return EnumInteractionResult.e;
        }
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!BlockRespawnAnchor.a(worldserver, blockposition)) {
                this.a(iblockdata, worldserver, blockposition);
                return EnumInteractionResult.b;
            }
            if (entityhuman instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityhuman;
                EntityPlayer.RespawnConfig entityplayer_respawnconfig = entityplayer.V();
                EntityPlayer.RespawnConfig entityplayer_respawnconfig1 = new EntityPlayer.RespawnConfig(WorldData.a.a(worldserver.aq(), blockposition, 0.0f, 0.0f), false);
                if (entityplayer_respawnconfig == null || !entityplayer_respawnconfig.a(entityplayer_respawnconfig1)) {
                    entityplayer.setRespawnPosition(entityplayer_respawnconfig1, true, PlayerSpawnChangeEvent.Cause.RESPAWN_ANCHOR);
                    worldserver.a((Entity)null, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, SoundEffects.yt, SoundCategory.e, 1.0f, 1.0f);
                    return EnumInteractionResult.b;
                }
            }
            return EnumInteractionResult.c;
        }
        return EnumInteractionResult.c;
    }

    private static boolean a(ItemStack itemstack) {
        return itemstack.a(Items.gd);
    }

    private static boolean p(IBlockData iblockdata) {
        return iblockdata.c(d) < 4;
    }

    private static boolean a(BlockPosition blockposition, World world) {
        Fluid fluid = world.b_(blockposition);
        if (!fluid.a(TagsFluid.a)) {
            return false;
        }
        if (fluid.b()) {
            return true;
        }
        float f2 = fluid.e();
        if (f2 < 2.0f) {
            return false;
        }
        Fluid fluid1 = world.b_(blockposition.e());
        return !fluid1.a(TagsFluid.a);
    }

    private void a(IBlockData iblockdata, WorldServer worldserver, final BlockPosition blockposition) {
        BlockState blockState = CraftBlock.at(worldserver, blockposition).getState();
        worldserver.a(blockposition, false);
        Stream<EnumDirection> stream = EnumDirection.EnumDirectionLimit.a.a();
        Objects.requireNonNull(blockposition);
        boolean flag = stream.map(blockposition::a).anyMatch(blockposition1 -> BlockRespawnAnchor.a(blockposition1, worldserver));
        final boolean flag1 = flag || worldserver.b_(blockposition.d()).a(TagsFluid.a);
        ExplosionDamageCalculator explosiondamagecalculator = new ExplosionDamageCalculator(this){

            @Override
            public Optional<Float> a(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition1, IBlockData iblockdata1, Fluid fluid) {
                return blockposition1.equals(blockposition) && flag1 ? Optional.of(Float.valueOf(Blocks.J.e())) : super.a(explosion, iblockaccess, blockposition1, iblockdata1, fluid);
            }
        };
        Vec3D vec3d = blockposition.b();
        worldserver.a((Entity)null, worldserver.as().badRespawnPointExplosion(vec3d, blockState), explosiondamagecalculator, vec3d, 5.0f, true, World.a.b);
    }

    public static boolean a(WorldServer worldserver, BlockPosition blockposition) {
        return worldserver.c().a(EnvironmentAttributes.D, blockposition);
    }

    public static void a(@Nullable Entity entity, World world, BlockPosition blockposition, IBlockData iblockdata) {
        IBlockData iblockdata1 = (IBlockData)iblockdata.b(d, iblockdata.c(d) + 1);
        world.a(blockposition, iblockdata1, 3);
        world.a(GameEvent.c, blockposition, GameEvent.a.a(entity, iblockdata1));
        world.a((Entity)null, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, SoundEffects.yr, SoundCategory.e, 1.0f, 1.0f);
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.c(d) != 0) {
            if (randomsource.a(100) == 0) {
                world.a(blockposition, SoundEffects.yq, SoundCategory.e, 1.0f, 1.0f, false);
            }
            double d0 = (double)blockposition.u() + 0.5 + (0.5 - randomsource.j());
            double d1 = (double)blockposition.v() + 1.0;
            double d2 = (double)blockposition.w() + 0.5 + (0.5 - randomsource.j());
            double d3 = (double)randomsource.i() * 0.04;
            world.a(Particles.aL, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{d});
    }

    @Override
    protected boolean c_(IBlockData iblockdata) {
        return true;
    }

    public static int a(IBlockData iblockdata, int i2) {
        return MathHelper.b((float)(iblockdata.c(d) - 0) / 4.0f * (float)i2);
    }

    @Override
    protected int a(IBlockData iblockdata, World world, BlockPosition blockposition, EnumDirection enumdirection) {
        return BlockRespawnAnchor.a(iblockdata, 15);
    }

    public static Optional<Vec3D> a(EntityTypes<?> entitytypes, ICollisionAccess icollisionaccess, BlockPosition blockposition) {
        Optional<Vec3D> optional = BlockRespawnAnchor.a(entitytypes, icollisionaccess, blockposition, true);
        return optional.isPresent() ? optional : BlockRespawnAnchor.a(entitytypes, icollisionaccess, blockposition, false);
    }

    private static Optional<Vec3D> a(EntityTypes<?> entitytypes, ICollisionAccess icollisionaccess, BlockPosition blockposition, boolean flag) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (BaseBlockPosition baseblockposition : f) {
            blockposition_mutableblockposition.g(blockposition).h(baseblockposition);
            Vec3D vec3d = DismountUtil.a(entitytypes, icollisionaccess, blockposition_mutableblockposition, flag);
            if (vec3d == null) continue;
            return Optional.of(vec3d);
        }
        return Optional.empty();
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }
}

