/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import com.mojang.logging.LogUtils;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.slf4j.Logger;

public class ChunkStatusTasks {
    private static final Logger a = LogUtils.getLogger();

    private static boolean a(IChunkAccess ichunkaccess) {
        return ichunkaccess.n().a(ChunkStatus.l) && ichunkaccess.x();
    }

    static CompletableFuture<IChunkAccess> a(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> b(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        if (worldserver.I.x().d()) {
            worldgencontext.b().a(worldserver.J_(), worldserver.p().h(), worldserver.b(), ichunkaccess, worldgencontext.c(), worldserver.aq());
        }
        worldserver.a(ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> c(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        worldgencontext.a().a(ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> d(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, staticcache2d, chunkstep, ichunkaccess);
        worldgencontext.b().a((GeneratorAccessSeed)regionlimitedworldaccess, worldserver.b().a(regionlimitedworldaccess), ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> e(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, staticcache2d, chunkstep, ichunkaccess);
        return worldgencontext.b().a(worldserver.p().i(), Blender.a(regionlimitedworldaccess), worldserver.b().a(regionlimitedworldaccess), ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> f(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, staticcache2d, chunkstep, ichunkaccess);
        return worldgencontext.b().a(Blender.a(regionlimitedworldaccess), worldserver.p().i(), worldserver.b().a(regionlimitedworldaccess), ichunkaccess).thenApply(ichunkaccess1 -> {
            ProtoChunk protochunk;
            BelowZeroRetrogen belowzeroretrogen;
            if (ichunkaccess1 instanceof ProtoChunk && (belowzeroretrogen = (protochunk = (ProtoChunk)ichunkaccess1).z()) != null) {
                BelowZeroRetrogen.a(protochunk);
                if (belowzeroretrogen.b()) {
                    belowzeroretrogen.b(protochunk);
                }
            }
            return ichunkaccess1;
        });
    }

    static CompletableFuture<IChunkAccess> g(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, staticcache2d, chunkstep, ichunkaccess);
        worldgencontext.b().a(regionlimitedworldaccess, worldserver.b().a(regionlimitedworldaccess), worldserver.p().i(), ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> h(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, staticcache2d, chunkstep, ichunkaccess);
        if (ichunkaccess instanceof ProtoChunk) {
            ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
            Blender.a((GeneratorAccessSeed)regionlimitedworldaccess, protochunk);
        }
        worldgencontext.b().a(regionlimitedworldaccess, worldserver.J(), worldserver.p().i(), worldserver.H_(), worldserver.b().a(regionlimitedworldaccess), ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> i(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        HeightMap.a(ichunkaccess, EnumSet.of(HeightMap.Type.e, HeightMap.Type.f, HeightMap.Type.d, HeightMap.Type.b));
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, staticcache2d, chunkstep, ichunkaccess);
        if (!SharedConstants.aD) {
            worldgencontext.b().a((GeneratorAccessSeed)regionlimitedworldaccess, ichunkaccess, worldserver.b().a(regionlimitedworldaccess));
        }
        Blender.a(regionlimitedworldaccess, ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> j(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        LightEngineThreaded lightenginethreaded = worldgencontext.d();
        ichunkaccess.C();
        ((ProtoChunk)ichunkaccess).a(lightenginethreaded);
        boolean flag = ChunkStatusTasks.a(ichunkaccess);
        return lightenginethreaded.a(ichunkaccess, flag);
    }

    static CompletableFuture<IChunkAccess> k(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        boolean flag = ChunkStatusTasks.a(ichunkaccess);
        return worldgencontext.d().b(ichunkaccess, flag);
    }

    static CompletableFuture<IChunkAccess> l(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        if (!ichunkaccess.A()) {
            worldgencontext.b().a(new RegionLimitedWorldAccess(worldgencontext.a(), staticcache2d, chunkstep, ichunkaccess));
        }
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> m(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        GenerationChunkHolder generationchunkholder = staticcache2d.a(chunkcoordintpair.h, chunkcoordintpair.i);
        return CompletableFuture.supplyAsync(() -> {
            Chunk chunk;
            ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
            WorldServer worldserver = worldgencontext.a();
            if (protochunk instanceof ProtoChunkExtension) {
                ProtoChunkExtension protochunkextension = (ProtoChunkExtension)protochunk;
                chunk = protochunkextension.H();
            } else {
                chunk = new Chunk(worldserver, protochunk, chunk1 -> {
                    try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(ichunkaccess.E(), a);){
                        ChunkStatusTasks.a(worldserver, TagValueInput.a((ProblemReporter)problemreporter_j, (HolderLookup.a)worldserver.J_(), protochunk.J()));
                    }
                });
                generationchunkholder.a(new ProtoChunkExtension(chunk, false));
            }
            Objects.requireNonNull(generationchunkholder);
            chunk.b(generationchunkholder::s);
            chunk.H();
            chunk.b(true);
            chunk.L();
            chunk.b(worldserver);
            chunk.a(worldgencontext.f());
            return chunk;
        }, worldgencontext.e());
    }

    private static void a(WorldServer worldserver, ValueInput.b valueinput_b) {
        if (!valueinput_b.a()) {
            worldserver.b(EntityTypes.a(valueinput_b, (World)worldserver, EntitySpawnReason.r));
        }
    }
}

