/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.PairedQueue;
import net.minecraft.util.thread.PriorityConsecutiveExecutor;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class IOWorker
implements ChunkScanAccess,
AutoCloseable {
    public static final Supplier<NBTTagCompound> a = () -> null;
    private static final Logger b = LogUtils.getLogger();
    private final AtomicBoolean c = new AtomicBoolean();
    private final PriorityConsecutiveExecutor d;
    private final RegionFileCache e;
    private final SequencedMap<ChunkCoordIntPair, a> f = new LinkedHashMap<ChunkCoordIntPair, a>();
    private final Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> g = new Long2ObjectLinkedOpenHashMap();
    private static final int h = 1024;

    protected IOWorker(RegionStorageInfo var0, Path var1, boolean var2) {
        this.e = new RegionFileCache(var0, var1, var2);
        this.d = new PriorityConsecutiveExecutor(Priority.values().length, (Executor)SystemUtils.i(), "IOWorker-" + var0.c());
    }

    public boolean a(ChunkCoordIntPair var0, int var1) {
        ChunkCoordIntPair var2 = new ChunkCoordIntPair(var0.h - var1, var0.i - var1);
        ChunkCoordIntPair var3 = new ChunkCoordIntPair(var0.h + var1, var0.i + var1);
        for (int var4 = var2.i(); var4 <= var3.i(); ++var4) {
            for (int var5 = var2.j(); var5 <= var3.j(); ++var5) {
                BitSet var6 = this.a(var4, var5).join();
                if (var6.isEmpty()) continue;
                ChunkCoordIntPair var7 = ChunkCoordIntPair.a(var4, var5);
                int var8 = Math.max(var2.h - var7.h, 0);
                int var9 = Math.max(var2.i - var7.i, 0);
                int var10 = Math.min(var3.h - var7.h, 31);
                int var11 = Math.min(var3.i - var7.i, 31);
                for (int var12 = var8; var12 <= var10; ++var12) {
                    for (int var13 = var9; var13 <= var11; ++var13) {
                        int var14 = var13 * 32 + var12;
                        if (!var6.get(var14)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<BitSet> a(int var0, int var1) {
        long var2 = ChunkCoordIntPair.d(var0, var1);
        Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> long2ObjectLinkedOpenHashMap = this.g;
        synchronized (long2ObjectLinkedOpenHashMap) {
            CompletableFuture<BitSet> var5 = (CompletableFuture<BitSet>)this.g.getAndMoveToFirst(var2);
            if (var5 == null) {
                var5 = this.b(var0, var1);
                this.g.putAndMoveToFirst(var2, var5);
                if (this.g.size() > 1024) {
                    this.g.removeLast();
                }
            }
            return var5;
        }
    }

    private CompletableFuture<BitSet> b(int var0, int var1) {
        return CompletableFuture.supplyAsync(() -> {
            ChunkCoordIntPair var2 = ChunkCoordIntPair.a(var0, var1);
            ChunkCoordIntPair var3 = ChunkCoordIntPair.b(var0, var1);
            BitSet var4 = new BitSet();
            ChunkCoordIntPair.a(var2, var3).forEach(var1 -> {
                NBTTagCompound var4;
                CollectFields var2 = new CollectFields(new FieldSelector(NBTTagInt.a, "DataVersion"), new FieldSelector(NBTTagCompound.b, "blending_data"));
                try {
                    this.a((ChunkCoordIntPair)var1, var2).join();
                }
                catch (Exception var3) {
                    b.warn("Failed to scan chunk {}", var1, (Object)var3);
                    return;
                }
                NBTBase var3 = var2.d();
                if (var3 instanceof NBTTagCompound && this.a(var4 = (NBTTagCompound)var3)) {
                    int var5 = var1.l() * 32 + var1.k();
                    var4.set(var5);
                }
            });
            return var4;
        }, SystemUtils.h());
    }

    private boolean a(NBTTagCompound var0) {
        if (var0.b("DataVersion", 0) < 4295) {
            return true;
        }
        return var0.m("blending_data").isPresent();
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair var0, NBTTagCompound var1) {
        return this.a(var0, () -> var1);
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair var0, Supplier<NBTTagCompound> var1) {
        return this.a(() -> {
            NBTTagCompound var2 = (NBTTagCompound)var1.get();
            a var3 = this.f.computeIfAbsent(var0, var1 -> new a(var2));
            var3.a = var2;
            return var3.b;
        }).thenCompose(Function.identity());
    }

    public CompletableFuture<Optional<NBTTagCompound>> a(ChunkCoordIntPair var0) {
        return this.a(() -> {
            a var1 = (a)this.f.get(var0);
            if (var1 != null) {
                return Optional.ofNullable(var1.a());
            }
            try {
                NBTTagCompound var2 = this.e.a(var0);
                return Optional.ofNullable(var2);
            }
            catch (Exception var2) {
                b.warn("Failed to read chunk {}", (Object)var0, (Object)var2);
                throw var2;
            }
        });
    }

    public CompletableFuture<Void> a(boolean var02) {
        CompletionStage var1 = this.a(() -> CompletableFuture.allOf((CompletableFuture[])this.f.values().stream().map(var0 -> var0.b).toArray(CompletableFuture[]::new))).thenCompose(Function.identity());
        if (var02) {
            return ((CompletableFuture)var1).thenCompose(var0 -> this.a(() -> {
                try {
                    this.e.a();
                    return null;
                }
                catch (Exception var0) {
                    b.warn("Failed to synchronize chunks", (Throwable)var0);
                    throw var0;
                }
            }));
        }
        return ((CompletableFuture)var1).thenCompose(var0 -> this.a(() -> null));
    }

    @Override
    public CompletableFuture<Void> a(ChunkCoordIntPair var0, StreamTagVisitor var1) {
        return this.a(() -> {
            try {
                a var2 = (a)this.f.get(var0);
                if (var2 != null) {
                    if (var2.a != null) {
                        var2.a.b(var1);
                    }
                } else {
                    this.e.a(var0, var1);
                }
                return null;
            }
            catch (Exception var2) {
                b.warn("Failed to bulk scan chunk {}", (Object)var0, (Object)var2);
                throw var2;
            }
        });
    }

    private <T> CompletableFuture<T> a(c<T> var0) {
        return this.d.a(Priority.a.ordinal(), (CompletableFuture<Source> var1) -> {
            if (!this.c.get()) {
                try {
                    var1.complete(var0.get());
                }
                catch (Exception var2) {
                    var1.completeExceptionally(var2);
                }
            }
            this.c();
        });
    }

    private <T> CompletableFuture<T> a(Supplier<T> var0) {
        return this.d.a(Priority.a.ordinal(), (CompletableFuture<Source> var1) -> {
            if (!this.c.get()) {
                var1.complete(var0.get());
            }
            this.c();
        });
    }

    private void b() {
        Map.Entry<ChunkCoordIntPair, a> var0 = this.f.pollFirstEntry();
        if (var0 == null) {
            return;
        }
        this.a(var0.getKey(), var0.getValue());
        this.c();
    }

    private void c() {
        this.d.a_(new PairedQueue.c(Priority.b.ordinal(), this::b));
    }

    private void a(ChunkCoordIntPair var0, a var1) {
        try {
            this.e.a(var0, var1.a);
            var1.b.complete(null);
        }
        catch (Exception var2) {
            b.error("Failed to store chunk {}", (Object)var0, (Object)var2);
            var1.b.completeExceptionally(var2);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.c.compareAndSet(false, true)) {
            return;
        }
        this.d();
        this.d.close();
        try {
            this.e.close();
        }
        catch (Exception var0) {
            b.error("Failed to close storage", (Throwable)var0);
        }
    }

    private void d() {
        this.d.a(Priority.c.ordinal(), (CompletableFuture<Source> var0) -> var0.complete(Unit.a)).join();
    }

    public RegionStorageInfo a() {
        return this.e.b();
    }

    static final class Priority
    extends Enum<Priority> {
        public static final /* enum */ Priority a = new Priority();
        public static final /* enum */ Priority b = new Priority();
        public static final /* enum */ Priority c = new Priority();
        private static final /* synthetic */ Priority[] d;

        public static Priority[] values() {
            return (Priority[])d.clone();
        }

        public static Priority valueOf(String var0) {
            return Enum.valueOf(Priority.class, var0);
        }

        private static /* synthetic */ Priority[] a() {
            return new Priority[]{a, b, c};
        }

        static {
            d = Priority.a();
        }
    }

    @FunctionalInterface
    static interface c<T> {
        public @Nullable T get() throws Exception;
    }

    static class a {
        @Nullable NBTTagCompound a;
        final CompletableFuture<Void> b = new CompletableFuture();

        public a(@Nullable NBTTagCompound var0) {
            this.a = var0;
        }

        @Nullable NBTTagCompound a() {
            NBTTagCompound var0 = this.a;
            return var0 == null ? null : var0.l();
        }
    }
}

