/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.timeline.Timeline;

public final class DimensionManager
extends Record {
    private final boolean m;
    private final boolean n;
    private final boolean o;
    private final double p;
    private final int q;
    private final int r;
    private final int s;
    private final TagKey<Block> t;
    private final float u;
    private final b v;
    private final c w;
    private final a x;
    private final EnvironmentAttributeMap y;
    private final HolderSet<Timeline> z;
    public static final int a = BlockPosition.e;
    public static final int b = 16;
    public static final int c = (1 << a) - 32;
    public static final int d = (c >> 1) - 1;
    public static final int e = d - c + 1;
    public static final int f = d << 4;
    public static final int g = e << 4;
    public static final Codec<DimensionManager> h = DimensionManager.a(EnvironmentAttributeMap.b);
    public static final Codec<DimensionManager> i = DimensionManager.a(EnvironmentAttributeMap.c);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<DimensionManager>> j = ByteBufCodecs.b(Registries.bd);
    public static final float[] k = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    public static final Codec<Holder<DimensionManager>> l = RegistryFileCodec.a(Registries.bd, h);

    public DimensionManager(boolean var0, boolean var1, boolean var2, double var3, int var5, int var6, int var7, TagKey<Block> var8, float var9, b var10, c var11, a var12, EnvironmentAttributeMap var13, HolderSet<Timeline> var14) {
        if (var6 < 16) {
            throw new IllegalStateException("height has to be at least 16");
        }
        if (var5 + var6 > d + 1) {
            throw new IllegalStateException("min_y + height cannot be higher than: " + (d + 1));
        }
        if (var7 > var6) {
            throw new IllegalStateException("logical_height cannot be higher than height");
        }
        if (var6 % 16 != 0) {
            throw new IllegalStateException("height has to be multiple of 16");
        }
        if (var5 % 16 != 0) {
            throw new IllegalStateException("min_y has to be a multiple of 16");
        }
        this.m = var0;
        this.n = var1;
        this.o = var2;
        this.p = var3;
        this.q = var5;
        this.r = var6;
        this.s = var7;
        this.t = var8;
        this.u = var9;
        this.v = var10;
        this.w = var11;
        this.x = var12;
        this.y = var13;
        this.z = var14;
    }

    private static Codec<DimensionManager> a(Codec<EnvironmentAttributeMap> var0) {
        return ExtraCodecs.e(RecordCodecBuilder.create(var1 -> var1.group((App)Codec.BOOL.optionalFieldOf("has_fixed_time", (Object)false).forGetter(DimensionManager::d), (App)Codec.BOOL.fieldOf("has_skylight").forGetter(DimensionManager::e), (App)Codec.BOOL.fieldOf("has_ceiling").forGetter(DimensionManager::f), (App)Codec.doubleRange((double)1.0E-5f, (double)3.0E7).fieldOf("coordinate_scale").forGetter(DimensionManager::g), (App)Codec.intRange((int)e, (int)d).fieldOf("min_y").forGetter(DimensionManager::h), (App)Codec.intRange((int)16, (int)c).fieldOf("height").forGetter(DimensionManager::i), (App)Codec.intRange((int)0, (int)c).fieldOf("logical_height").forGetter(DimensionManager::j), (App)TagKey.b(Registries.i).fieldOf("infiniburn").forGetter(DimensionManager::k), (App)Codec.FLOAT.fieldOf("ambient_light").forGetter(DimensionManager::l), (App)net.minecraft.world.level.dimension.DimensionManager$b.a.forGetter(DimensionManager::m), (App)net.minecraft.world.level.dimension.DimensionManager$c.d.optionalFieldOf("skybox", (Object)net.minecraft.world.level.dimension.DimensionManager$c.b).forGetter(DimensionManager::n), (App)net.minecraft.world.level.dimension.DimensionManager$a.c.optionalFieldOf("cardinal_light", (Object)net.minecraft.world.level.dimension.DimensionManager$a.a).forGetter(DimensionManager::o), (App)var0.optionalFieldOf("attributes", (Object)EnvironmentAttributeMap.a).forGetter(DimensionManager::p), (App)RegistryCodecs.a(Registries.bw).optionalFieldOf("timelines", HolderSet.f()).forGetter(DimensionManager::q)).apply((Applicative)var1, DimensionManager::new)));
    }

    public static double a(DimensionManager var0, DimensionManager var1) {
        double var2 = var0.g();
        double var4 = var1.g();
        return var2 / var4;
    }

    public static Path a(ResourceKey<World> var0, Path var1) {
        if (var0 == World.h) {
            return var1;
        }
        if (var0 == World.j) {
            return var1.resolve("DIM1");
        }
        if (var0 == World.i) {
            return var1.resolve("DIM-1");
        }
        return var1.resolve("dimensions").resolve(var0.a().b()).resolve(var0.a().a());
    }

    public IntProvider a() {
        return this.v.a();
    }

    public int b() {
        return this.v.b();
    }

    public boolean c() {
        return this.w == net.minecraft.world.level.dimension.DimensionManager$c.c;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DimensionManager.class, "hasFixedTime;hasSkyLight;hasCeiling;coordinateScale;minY;height;logicalHeight;infiniburn;ambientLight;monsterSettings;skybox;cardinalLightType;attributes;timelines", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DimensionManager.class, "hasFixedTime;hasSkyLight;hasCeiling;coordinateScale;minY;height;logicalHeight;infiniburn;ambientLight;monsterSettings;skybox;cardinalLightType;attributes;timelines", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DimensionManager.class, "hasFixedTime;hasSkyLight;hasCeiling;coordinateScale;minY;height;logicalHeight;infiniburn;ambientLight;monsterSettings;skybox;cardinalLightType;attributes;timelines", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"}, this, var0);
    }

    public boolean d() {
        return this.m;
    }

    public boolean e() {
        return this.n;
    }

    public boolean f() {
        return this.o;
    }

    public double g() {
        return this.p;
    }

    public int h() {
        return this.q;
    }

    public int i() {
        return this.r;
    }

    public int j() {
        return this.s;
    }

    public TagKey<Block> k() {
        return this.t;
    }

    public float l() {
        return this.u;
    }

    public b m() {
        return this.v;
    }

    public c n() {
        return this.w;
    }

    public a o() {
        return this.x;
    }

    public EnvironmentAttributeMap p() {
        return this.y;
    }

    public HolderSet<Timeline> q() {
        return this.z;
    }

    public static final class b
    extends Record {
        private final IntProvider b;
        private final int c;
        public static final MapCodec<b> a = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)IntProvider.b(0, 15).fieldOf("monster_spawn_light_level").forGetter(b::a), (App)Codec.intRange((int)0, (int)15).fieldOf("monster_spawn_block_light_limit").forGetter(b::b)).apply((Applicative)var0, b::new));

        public b(IntProvider var0, int var1) {
            this.b = var0;
            this.c = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "monsterSpawnLightTest;monsterSpawnBlockLightLimit", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "monsterSpawnLightTest;monsterSpawnBlockLightLimit", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "monsterSpawnLightTest;monsterSpawnBlockLightLimit", "b", "c"}, this, var0);
        }

        public IntProvider a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }
    }

    public static final class c
    extends Enum<c>
    implements INamable {
        public static final /* enum */ c a = new c("none");
        public static final /* enum */ c b = new c("overworld");
        public static final /* enum */ c c = new c("end");
        public static final Codec<c> d;
        private final String e;
        private static final /* synthetic */ c[] f;

        public static c[] values() {
            return (c[])f.clone();
        }

        public static c valueOf(String var0) {
            return Enum.valueOf(c.class, var0);
        }

        private c(String var2) {
            this.e = var2;
        }

        @Override
        public String c() {
            return this.e;
        }

        private static /* synthetic */ c[] a() {
            return new c[]{a, b, c};
        }

        static {
            f = net.minecraft.world.level.dimension.DimensionManager$c.a();
            d = INamable.a(c::values);
        }
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a a = new a("default");
        public static final /* enum */ a b = new a("nether");
        public static final Codec<a> c;
        private final String d;
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(String var2) {
            this.d = var2;
        }

        @Override
        public String c() {
            return this.d;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b};
        }

        static {
            e = net.minecraft.world.level.dimension.DimensionManager$a.a();
            c = INamable.a(a::values);
        }
    }
}

