/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class RandomSpreadStructurePlacement
extends StructurePlacement {
    public static final MapCodec<RandomSpreadStructurePlacement> a = RecordCodecBuilder.mapCodec(var0 -> RandomSpreadStructurePlacement.a(var0).and(var0.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::a), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(RandomSpreadStructurePlacement::b), (App)RandomSpreadType.c.optionalFieldOf("spread_type", (Object)RandomSpreadType.a).forGetter(RandomSpreadStructurePlacement::c))).apply((Applicative)var0, RandomSpreadStructurePlacement::new)).validate(RandomSpreadStructurePlacement::a);
    private final int c;
    private final int d;
    private final RandomSpreadType e;

    private static DataResult<RandomSpreadStructurePlacement> a(RandomSpreadStructurePlacement var0) {
        if (var0.c <= var0.d) {
            return DataResult.error(() -> "Spacing has to be larger than separation");
        }
        return DataResult.success((Object)var0);
    }

    public RandomSpreadStructurePlacement(BaseBlockPosition var0, StructurePlacement.c var1, float var2, int var3, Optional<StructurePlacement.a> var4, int var5, int var6, RandomSpreadType var7) {
        super(var0, var1, var2, var3, var4);
        this.c = var5;
        this.d = var6;
        this.e = var7;
    }

    public RandomSpreadStructurePlacement(int var0, int var1, RandomSpreadType var2, int var3) {
        this(BaseBlockPosition.i, StructurePlacement.c.a, 1.0f, var3, Optional.empty(), var0, var1, var2);
    }

    public int a() {
        return this.c;
    }

    public int b() {
        return this.d;
    }

    public RandomSpreadType c() {
        return this.e;
    }

    public ChunkCoordIntPair a(long var0, int var2, int var3) {
        int var4 = Math.floorDiv(var2, this.c);
        int var5 = Math.floorDiv(var3, this.c);
        SeededRandom var6 = new SeededRandom(new LegacyRandomSource(0L));
        var6.a(var0, var4, var5, this.i());
        int var7 = this.c - this.d;
        int var8 = this.e.a(var6, var7);
        int var9 = this.e.a(var6, var7);
        return new ChunkCoordIntPair(var4 * this.c + var8, var5 * this.c + var9);
    }

    @Override
    protected boolean a(ChunkGeneratorStructureState var0, int var1, int var2) {
        ChunkCoordIntPair var3 = this.a(var0.d(), var1, var2);
        return var3.h == var1 && var3.i == var2;
    }

    @Override
    public StructurePlacementType<?> e() {
        return StructurePlacementType.a;
    }
}

