/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorJigsawReplacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class WorldGenFeatureDefinedStructurePoolSingle
extends WorldGenFeatureDefinedStructurePoolStructure {
    private static final Comparator<DefinedStructure.a> a = Comparator.comparingInt(DefinedStructure.a::g).reversed();
    private static final Codec<Either<MinecraftKey, DefinedStructure>> g = Codec.of(WorldGenFeatureDefinedStructurePoolSingle::a, (Decoder)MinecraftKey.a.map(Either::left));
    public static final MapCodec<WorldGenFeatureDefinedStructurePoolSingle> b = RecordCodecBuilder.mapCodec(var0 -> var0.group(WorldGenFeatureDefinedStructurePoolSingle.d(), WorldGenFeatureDefinedStructurePoolSingle.b(), WorldGenFeatureDefinedStructurePoolSingle.f(), WorldGenFeatureDefinedStructurePoolSingle.c()).apply((Applicative)var0, WorldGenFeatureDefinedStructurePoolSingle::new));
    protected final Either<MinecraftKey, DefinedStructure> c;
    protected final Holder<ProcessorList> d;
    protected final Optional<LiquidSettings> e;

    private static <T> DataResult<T> a(Either<MinecraftKey, DefinedStructure> var0, DynamicOps<T> var1, T var2) {
        Optional var3 = var0.left();
        if (var3.isEmpty()) {
            return DataResult.error(() -> "Can not serialize a runtime pool element");
        }
        return MinecraftKey.a.encode((Object)((MinecraftKey)var3.get()), var1, var2);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Holder<ProcessorList>> b() {
        return DefinedStructureStructureProcessorType.d.fieldOf("processors").forGetter(var0 -> var0.d);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Optional<LiquidSettings>> c() {
        return LiquidSettings.c.optionalFieldOf("override_liquid_settings").forGetter(var0 -> var0.e);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Either<MinecraftKey, DefinedStructure>> d() {
        return g.fieldOf("location").forGetter(var0 -> var0.c);
    }

    protected WorldGenFeatureDefinedStructurePoolSingle(Either<MinecraftKey, DefinedStructure> var0, Holder<ProcessorList> var1, WorldGenFeatureDefinedStructurePoolTemplate.Matching var2, Optional<LiquidSettings> var3) {
        super(var2);
        this.c = var0;
        this.d = var1;
        this.e = var3;
    }

    @Override
    public BaseBlockPosition a(StructureTemplateManager var0, EnumBlockRotation var1) {
        DefinedStructure var2 = this.a(var0);
        return var2.a(var1);
    }

    private DefinedStructure a(StructureTemplateManager var0) {
        return (DefinedStructure)this.c.map(var0::a, Function.identity());
    }

    public List<DefinedStructure.BlockInfo> a(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2, boolean var3) {
        DefinedStructure var4 = this.a(var0);
        ObjectArrayList<DefinedStructure.BlockInfo> var5 = var4.a(var1, new DefinedStructureInfo().a(var2), Blocks.pY, var3);
        ArrayList var6 = Lists.newArrayList();
        for (DefinedStructure.BlockInfo var8 : var5) {
            BlockPropertyStructureMode var10;
            NBTTagCompound var9 = var8.c();
            if (var9 == null || (var10 = var9.a("mode", BlockPropertyStructureMode.e).orElseThrow()) != BlockPropertyStructureMode.d) continue;
            var6.add(var8);
        }
        return var6;
    }

    @Override
    public List<DefinedStructure.a> a(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2, RandomSource var3) {
        List<DefinedStructure.a> var4 = this.a(var0).a(var1, var2);
        SystemUtils.c(var4, var3);
        WorldGenFeatureDefinedStructurePoolSingle.a(var4);
        return var4;
    }

    @VisibleForTesting
    static void a(List<DefinedStructure.a> var0) {
        var0.sort(a);
    }

    @Override
    public StructureBoundingBox a(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2) {
        DefinedStructure var3 = this.a(var0);
        return var3.b(new DefinedStructureInfo().a(var2), var1);
    }

    @Override
    public boolean a(StructureTemplateManager var0, GeneratorAccessSeed var1, StructureManager var2, ChunkGenerator var3, BlockPosition var4, BlockPosition var5, EnumBlockRotation var6, StructureBoundingBox var7, RandomSource var8, LiquidSettings var9, boolean var10) {
        DefinedStructureInfo var12;
        DefinedStructure var11 = this.a(var0);
        if (var11.a(var1, var4, var5, var12 = this.a(var6, var7, var9, var10), var8, 18)) {
            List<DefinedStructure.BlockInfo> var13 = DefinedStructure.a(var1, var4, var5, var12, this.a(var0, var4, var6, false));
            for (DefinedStructure.BlockInfo var15 : var13) {
                this.a(var1, var15, var4, var6, var8, var7);
            }
            return true;
        }
        return false;
    }

    protected DefinedStructureInfo a(EnumBlockRotation var0, StructureBoundingBox var1, LiquidSettings var2, boolean var3) {
        DefinedStructureInfo var4 = new DefinedStructureInfo();
        var4.a(var1);
        var4.a(var0);
        var4.b(true);
        var4.a(false);
        var4.a(DefinedStructureProcessorBlockIgnore.b);
        var4.c(true);
        var4.a(this.e.orElse(var2));
        if (!var3) {
            var4.a(DefinedStructureProcessorJigsawReplacement.b);
        }
        this.d.a().a().forEach(var4::a);
        this.g().b().forEach(var4::a);
        return var4;
    }

    @Override
    public WorldGenFeatureDefinedStructurePools<?> a() {
        return WorldGenFeatureDefinedStructurePools.a;
    }

    public String toString() {
        return "Single[" + String.valueOf(this.c) + "]";
    }

    @VisibleForTesting
    public MinecraftKey e() {
        return (MinecraftKey)this.c.orThrow();
    }
}

