/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.SinglePieceStructure;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidPiece;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R7.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBrushableBlock;
import org.bukkit.craftbukkit.v1_21_R7.util.TransformerGeneratorAccess;

public class DesertPyramidStructure
extends SinglePieceStructure {
    public static final MapCodec<DesertPyramidStructure> d = DesertPyramidStructure.a(DesertPyramidStructure::new);

    public DesertPyramidStructure(Structure.c structure_c) {
        super(DesertPyramidPiece::new, 21, 21, structure_c);
    }

    @Override
    public void a(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, PiecesContainer piecescontainer) {
        Comparator set = ArraySetSorted.a(BaseBlockPosition::i);
        for (StructurePiece structurepiece : piecescontainer.c()) {
            if (!(structurepiece instanceof DesertPyramidPiece)) continue;
            DesertPyramidPiece desertpyramidpiece = (DesertPyramidPiece)structurepiece;
            set.addAll(desertpyramidpiece.b());
            DesertPyramidStructure.a(structureboundingbox, generatoraccessseed, desertpyramidpiece.c());
        }
        ObjectArrayList objectarraylist = new ObjectArrayList(set.stream().toList());
        RandomSource randomsource1 = RandomSource.a(generatoraccessseed.J()).e().a(piecescontainer.b().g());
        SystemUtils.c(objectarraylist, randomsource1);
        int i2 = Math.min(set.size(), randomsource1.b(5, 8));
        for (BlockPosition blockposition : objectarraylist) {
            if (i2 > 0) {
                --i2;
                DesertPyramidStructure.a(structureboundingbox, generatoraccessseed, blockposition);
                continue;
            }
            if (!structureboundingbox.b(blockposition)) continue;
            generatoraccessseed.a(blockposition, Blocks.L.m(), 2);
        }
    }

    private static void a(StructureBoundingBox structureboundingbox, GeneratorAccessSeed generatoraccessseed, BlockPosition blockposition) {
        if (structureboundingbox.b(blockposition)) {
            if (generatoraccessseed instanceof TransformerGeneratorAccess) {
                TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)generatoraccessseed;
                CraftBrushableBlock brushableState = (CraftBrushableBlock)CraftBlockStates.getBlockState((IWorldReader)generatoraccessseed, blockposition, Blocks.M.m(), null);
                brushableState.setLootTable(CraftLootTable.minecraftToBukkit(LootTables.bk));
                brushableState.setSeed(blockposition.a());
                transformerAccess.setCraftBlock(blockposition, brushableState, 2);
                return;
            }
            generatoraccessseed.a(blockposition, Blocks.M.m(), 2);
            generatoraccessseed.a(blockposition, TileEntityTypes.P).ifPresent(brushableblockentity -> brushableblockentity.a(LootTables.bk, blockposition.a()));
        }
    }

    @Override
    public StructureType<?> e() {
        return StructureType.b;
    }
}

