/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.phys.Vec2F;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Vec3D
implements IPosition {
    public static final Codec<Vec3D> a = Codec.DOUBLE.listOf().comapFlatMap(var02 -> SystemUtils.a(var02, 3).map(var0 -> new Vec3D((Double)var0.get(0), (Double)var0.get(1), (Double)var0.get(2))), var0 -> List.of(Double.valueOf(var0.a()), Double.valueOf(var0.b()), Double.valueOf(var0.c())));
    public static final StreamCodec<ByteBuf, Vec3D> b = new StreamCodec<ByteBuf, Vec3D>(){

        public Vec3D a(ByteBuf var0) {
            return PacketDataSerializer.g(var0);
        }

        public void a(ByteBuf var0, Vec3D var1) {
            PacketDataSerializer.a(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Vec3D)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final Vec3D c = new Vec3D(0.0, 0.0, 0.0);
    public static final Vec3D d = new Vec3D(1.0, 0.0, 0.0);
    public static final Vec3D e = new Vec3D(0.0, 1.0, 0.0);
    public static final Vec3D f = new Vec3D(0.0, 0.0, 1.0);
    public final double g;
    public final double h;
    public final double i;

    public static Vec3D a(BaseBlockPosition var0) {
        return new Vec3D(var0.u(), var0.v(), var0.w());
    }

    public static Vec3D a(BaseBlockPosition var0, double var1, double var3, double var5) {
        return new Vec3D((double)var0.u() + var1, (double)var0.v() + var3, (double)var0.w() + var5);
    }

    public static Vec3D b(BaseBlockPosition var0) {
        return Vec3D.a(var0, 0.5, 0.5, 0.5);
    }

    public static Vec3D c(BaseBlockPosition var0) {
        return Vec3D.a(var0, 0.5, 0.0, 0.5);
    }

    public static Vec3D a(BaseBlockPosition var0, double var1) {
        return Vec3D.a(var0, 0.5, var1, 0.5);
    }

    public Vec3D(double var0, double var2, double var4) {
        this.g = var0;
        this.h = var2;
        this.i = var4;
    }

    public Vec3D(Vector3fc var0) {
        this(var0.x(), var0.y(), var0.z());
    }

    public Vec3D(BaseBlockPosition var0) {
        this(var0.u(), var0.v(), var0.w());
    }

    public Vec3D a(Vec3D var0) {
        return new Vec3D(var0.g - this.g, var0.h - this.h, var0.i - this.i);
    }

    public Vec3D d() {
        double var0 = Math.sqrt(this.g * this.g + this.h * this.h + this.i * this.i);
        if (var0 < (double)1.0E-5f) {
            return c;
        }
        return new Vec3D(this.g / var0, this.h / var0, this.i / var0);
    }

    public double b(Vec3D var0) {
        return this.g * var0.g + this.h * var0.h + this.i * var0.i;
    }

    public Vec3D c(Vec3D var0) {
        return new Vec3D(this.h * var0.i - this.i * var0.h, this.i * var0.g - this.g * var0.i, this.g * var0.h - this.h * var0.g);
    }

    public Vec3D d(Vec3D var0) {
        return this.a(var0.g, var0.h, var0.i);
    }

    public Vec3D a(double var0) {
        return this.a(var0, var0, var0);
    }

    public Vec3D a(double var0, double var2, double var4) {
        return this.b(-var0, -var2, -var4);
    }

    public Vec3D b(double var0) {
        return this.b(var0, var0, var0);
    }

    public Vec3D e(Vec3D var0) {
        return this.b(var0.g, var0.h, var0.i);
    }

    public Vec3D b(double var0, double var2, double var4) {
        return new Vec3D(this.g + var0, this.h + var2, this.i + var4);
    }

    public boolean a(IPosition var0, double var1) {
        return this.c(var0.a(), var0.b(), var0.c()) < var1 * var1;
    }

    public double f(Vec3D var0) {
        double var1 = var0.g - this.g;
        double var3 = var0.h - this.h;
        double var5 = var0.i - this.i;
        return Math.sqrt(var1 * var1 + var3 * var3 + var5 * var5);
    }

    public double g(Vec3D var0) {
        double var1 = var0.g - this.g;
        double var3 = var0.h - this.h;
        double var5 = var0.i - this.i;
        return var1 * var1 + var3 * var3 + var5 * var5;
    }

    public double c(double var0, double var2, double var4) {
        double var6 = var0 - this.g;
        double var8 = var2 - this.h;
        double var10 = var4 - this.i;
        return var6 * var6 + var8 * var8 + var10 * var10;
    }

    public boolean a(Vec3D var0, double var1, double var3) {
        double var5 = var0.a() - this.g;
        double var7 = var0.b() - this.h;
        double var9 = var0.c() - this.i;
        return MathHelper.e(var5, var9) < MathHelper.n(var1) && Math.abs(var7) < var3;
    }

    public Vec3D c(double var0) {
        return this.d(var0, var0, var0);
    }

    public Vec3D e() {
        return this.c(-1.0);
    }

    public Vec3D h(Vec3D var0) {
        return this.d(var0.g, var0.h, var0.i);
    }

    public Vec3D d(double var0, double var2, double var4) {
        return new Vec3D(this.g * var0, this.h * var2, this.i * var4);
    }

    public Vec3D f() {
        return new Vec3D(this.g, 0.0, this.i);
    }

    public Vec3D a(RandomSource var0, float var1) {
        return this.b((var0.i() - 0.5f) * var1, (var0.i() - 0.5f) * var1, (var0.i() - 0.5f) * var1);
    }

    public Vec3D b(RandomSource var0, float var1) {
        return this.b((var0.i() - 0.5f) * var1, 0.0, (var0.i() - 0.5f) * var1);
    }

    public double g() {
        return Math.sqrt(this.g * this.g + this.h * this.h + this.i * this.i);
    }

    public double h() {
        return this.g * this.g + this.h * this.h + this.i * this.i;
    }

    public double i() {
        return Math.sqrt(this.g * this.g + this.i * this.i);
    }

    public double j() {
        return this.g * this.g + this.i * this.i;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof Vec3D)) {
            return false;
        }
        Vec3D var1 = (Vec3D)var0;
        if (Double.compare(var1.g, this.g) != 0) {
            return false;
        }
        if (Double.compare(var1.h, this.h) != 0) {
            return false;
        }
        return Double.compare(var1.i, this.i) == 0;
    }

    public int hashCode() {
        long var1 = Double.doubleToLongBits(this.g);
        int var0 = (int)(var1 ^ var1 >>> 32);
        var1 = Double.doubleToLongBits(this.h);
        var0 = 31 * var0 + (int)(var1 ^ var1 >>> 32);
        var1 = Double.doubleToLongBits(this.i);
        var0 = 31 * var0 + (int)(var1 ^ var1 >>> 32);
        return var0;
    }

    public String toString() {
        return "(" + this.g + ", " + this.h + ", " + this.i + ")";
    }

    public Vec3D a(Vec3D var0, double var1) {
        return new Vec3D(MathHelper.d(var1, this.g, var0.g), MathHelper.d(var1, this.h, var0.h), MathHelper.d(var1, this.i, var0.i));
    }

    public Vec3D a(float var0) {
        float var1 = MathHelper.b((double)var0);
        float var2 = MathHelper.a((double)var0);
        double var3 = this.g;
        double var5 = this.h * (double)var1 + this.i * (double)var2;
        double var7 = this.i * (double)var1 - this.h * (double)var2;
        return new Vec3D(var3, var5, var7);
    }

    public Vec3D b(float var0) {
        float var1 = MathHelper.b((double)var0);
        float var2 = MathHelper.a((double)var0);
        double var3 = this.g * (double)var1 + this.i * (double)var2;
        double var5 = this.h;
        double var7 = this.i * (double)var1 - this.g * (double)var2;
        return new Vec3D(var3, var5, var7);
    }

    public Vec3D c(float var0) {
        float var1 = MathHelper.b((double)var0);
        float var2 = MathHelper.a((double)var0);
        double var3 = this.g * (double)var1 + this.h * (double)var2;
        double var5 = this.h * (double)var1 - this.g * (double)var2;
        double var7 = this.i;
        return new Vec3D(var3, var5, var7);
    }

    public Vec3D k() {
        return new Vec3D(-this.i, this.h, this.g);
    }

    public static Vec3D a(Vec2F var0) {
        return Vec3D.a(var0.j, var0.k);
    }

    public static Vec3D a(float var0, float var1) {
        float var2 = MathHelper.b((double)(-var1 * ((float)Math.PI / 180) - (float)Math.PI));
        float var3 = MathHelper.a((double)(-var1 * ((float)Math.PI / 180) - (float)Math.PI));
        float var4 = -MathHelper.b((double)(-var0 * ((float)Math.PI / 180)));
        float var5 = MathHelper.a((double)(-var0 * ((float)Math.PI / 180)));
        return new Vec3D(var3 * var4, var5, var2 * var4);
    }

    public Vec2F l() {
        float var0 = (float)Math.atan2(-this.g, this.i) * 57.295776f;
        float var1 = (float)Math.asin(-this.h / Math.sqrt(this.g * this.g + this.h * this.h + this.i * this.i)) * 57.295776f;
        return new Vec2F(var1, var0);
    }

    public Vec3D a(EnumSet<EnumDirection.EnumAxis> var0) {
        double var1 = var0.contains(EnumDirection.EnumAxis.a) ? (double)MathHelper.c(this.g) : this.g;
        double var3 = var0.contains(EnumDirection.EnumAxis.b) ? (double)MathHelper.c(this.h) : this.h;
        double var5 = var0.contains(EnumDirection.EnumAxis.c) ? (double)MathHelper.c(this.i) : this.i;
        return new Vec3D(var1, var3, var5);
    }

    public double a(EnumDirection.EnumAxis var0) {
        return var0.a(this.g, this.h, this.i);
    }

    public Vec3D a(EnumDirection.EnumAxis var0, double var1) {
        double var3 = var0 == EnumDirection.EnumAxis.a ? var1 : this.g;
        double var5 = var0 == EnumDirection.EnumAxis.b ? var1 : this.h;
        double var7 = var0 == EnumDirection.EnumAxis.c ? var1 : this.i;
        return new Vec3D(var3, var5, var7);
    }

    public Vec3D a(EnumDirection var0, double var1) {
        BaseBlockPosition var3 = var0.q();
        return new Vec3D(this.g + var1 * (double)var3.u(), this.h + var1 * (double)var3.v(), this.i + var1 * (double)var3.w());
    }

    @Override
    public final double a() {
        return this.g;
    }

    @Override
    public final double b() {
        return this.h;
    }

    @Override
    public final double c() {
        return this.i;
    }

    public Vector3f m() {
        return new Vector3f((float)this.g, (float)this.h, (float)this.i);
    }

    public Vec3D i(Vec3D var0) {
        if (var0.h() == 0.0) {
            return var0;
        }
        return var0.c(this.b(var0)).c(1.0 / var0.h());
    }

    public static Vec3D a(Vec2F var0, Vec3D var1) {
        float var2 = MathHelper.b((double)((var0.k + 90.0f) * ((float)Math.PI / 180)));
        float var3 = MathHelper.a((double)((var0.k + 90.0f) * ((float)Math.PI / 180)));
        float var4 = MathHelper.b((double)(-var0.j * ((float)Math.PI / 180)));
        float var5 = MathHelper.a((double)(-var0.j * ((float)Math.PI / 180)));
        float var6 = MathHelper.b((double)((-var0.j + 90.0f) * ((float)Math.PI / 180)));
        float var7 = MathHelper.a((double)((-var0.j + 90.0f) * ((float)Math.PI / 180)));
        Vec3D var8 = new Vec3D(var2 * var4, var5, var3 * var4);
        Vec3D var9 = new Vec3D(var2 * var6, var7, var3 * var6);
        Vec3D var10 = var8.c(var9).c(-1.0);
        double var11 = var8.g * var1.i + var9.g * var1.h + var10.g * var1.g;
        double var13 = var8.h * var1.i + var9.h * var1.h + var10.h * var1.g;
        double var15 = var8.i * var1.i + var9.i * var1.h + var10.i * var1.g;
        return new Vec3D(var11, var13, var15);
    }

    public Vec3D j(Vec3D var0) {
        return Vec3D.a(this.l(), var0);
    }

    public boolean n() {
        return Double.isFinite(this.g) && Double.isFinite(this.h) && Double.isFinite(this.i);
    }
}

