/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.math.DoubleMath;
import com.google.common.math.IntMath;
import com.mojang.math.PointGroupO;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeArray;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeCube;
import net.minecraft.world.phys.shapes.VoxelShapeCubeMerger;
import net.minecraft.world.phys.shapes.VoxelShapeCubePoint;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapeMerger;
import net.minecraft.world.phys.shapes.VoxelShapeMergerDisjoint;
import net.minecraft.world.phys.shapes.VoxelShapeMergerIdentical;
import net.minecraft.world.phys.shapes.VoxelShapeMergerList;
import net.minecraft.world.phys.shapes.VoxelShapeSlice;

public final class VoxelShapes {
    public static final double a = 1.0E-7;
    public static final double b = 1.0E-6;
    private static final VoxelShape d = SystemUtils.a(() -> {
        VoxelShapeBitSet var0 = new VoxelShapeBitSet(1, 1, 1);
        ((VoxelShapeDiscrete)var0).c(0, 0, 0);
        return new VoxelShapeCube(var0);
    });
    private static final Vec3D e = new Vec3D(0.5, 0.5, 0.5);
    public static final VoxelShape c = VoxelShapes.a(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final VoxelShape f = new VoxelShapeArray((VoxelShapeDiscrete)new VoxelShapeBitSet(0, 0, 0), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}));

    public static VoxelShape a() {
        return f;
    }

    public static VoxelShape b() {
        return d;
    }

    public static VoxelShape a(double var0, double var2, double var4, double var6, double var8, double var10) {
        if (var0 > var6 || var2 > var8 || var4 > var10) {
            throw new IllegalArgumentException("The min values need to be smaller or equals to the max values");
        }
        return VoxelShapes.b(var0, var2, var4, var6, var8, var10);
    }

    public static VoxelShape b(double var0, double var2, double var4, double var6, double var8, double var10) {
        if (var6 - var0 < 1.0E-7 || var8 - var2 < 1.0E-7 || var10 - var4 < 1.0E-7) {
            return VoxelShapes.a();
        }
        int var12 = VoxelShapes.a(var0, var6);
        int var13 = VoxelShapes.a(var2, var8);
        int var14 = VoxelShapes.a(var4, var10);
        if (var12 < 0 || var13 < 0 || var14 < 0) {
            return new VoxelShapeArray(VoxelShapes.d.a, (DoubleList)DoubleArrayList.wrap((double[])new double[]{var0, var6}), (DoubleList)DoubleArrayList.wrap((double[])new double[]{var2, var8}), (DoubleList)DoubleArrayList.wrap((double[])new double[]{var4, var10}));
        }
        if (var12 == 0 && var13 == 0 && var14 == 0) {
            return VoxelShapes.b();
        }
        int var15 = 1 << var12;
        int var16 = 1 << var13;
        int var17 = 1 << var14;
        VoxelShapeBitSet var18 = VoxelShapeBitSet.a(var15, var16, var17, (int)Math.round(var0 * (double)var15), (int)Math.round(var2 * (double)var16), (int)Math.round(var4 * (double)var17), (int)Math.round(var6 * (double)var15), (int)Math.round(var8 * (double)var16), (int)Math.round(var10 * (double)var17));
        return new VoxelShapeCube(var18);
    }

    public static VoxelShape a(AxisAlignedBB var0) {
        return VoxelShapes.b(var0.a, var0.b, var0.c, var0.d, var0.e, var0.f);
    }

    @VisibleForTesting
    protected static int a(double var0, double var2) {
        if (var0 < -1.0E-7 || var2 > 1.0000001) {
            return -1;
        }
        for (int var4 = 0; var4 <= 3; ++var4) {
            boolean var11;
            int var5 = 1 << var4;
            double var6 = var0 * (double)var5;
            double var8 = var2 * (double)var5;
            boolean var10 = Math.abs(var6 - (double)Math.round(var6)) < 1.0E-7 * (double)var5;
            boolean bl = var11 = Math.abs(var8 - (double)Math.round(var8)) < 1.0E-7 * (double)var5;
            if (!var10 || !var11) continue;
            return var4;
        }
        return -1;
    }

    protected static long a(int var0, int var1) {
        return (long)var0 * (long)(var1 / IntMath.gcd((int)var0, (int)var1));
    }

    public static VoxelShape a(VoxelShape var0, VoxelShape var1) {
        return VoxelShapes.a(var0, var1, OperatorBoolean.o);
    }

    public static VoxelShape a(VoxelShape var0, VoxelShape ... var1) {
        return Arrays.stream(var1).reduce(var0, VoxelShapes::a);
    }

    public static VoxelShape a(VoxelShape var0, VoxelShape var1, OperatorBoolean var2) {
        return VoxelShapes.b(var0, var1, var2).d();
    }

    public static VoxelShape b(VoxelShape var0, VoxelShape var1, OperatorBoolean var2) {
        if (var2.apply(false, false)) {
            throw SystemUtils.b(new IllegalArgumentException());
        }
        if (var0 == var1) {
            return var2.apply(true, true) ? var0 : VoxelShapes.a();
        }
        boolean var3 = var2.apply(true, false);
        boolean var4 = var2.apply(false, true);
        if (var0.c()) {
            return var4 ? var1 : VoxelShapes.a();
        }
        if (var1.c()) {
            return var3 ? var0 : VoxelShapes.a();
        }
        VoxelShapeMerger var5 = VoxelShapes.a(1, var0.a(EnumDirection.EnumAxis.a), var1.a(EnumDirection.EnumAxis.a), var3, var4);
        VoxelShapeMerger var6 = VoxelShapes.a(var5.size() - 1, var0.a(EnumDirection.EnumAxis.b), var1.a(EnumDirection.EnumAxis.b), var3, var4);
        VoxelShapeMerger var7 = VoxelShapes.a((var5.size() - 1) * (var6.size() - 1), var0.a(EnumDirection.EnumAxis.c), var1.a(EnumDirection.EnumAxis.c), var3, var4);
        VoxelShapeBitSet var8 = VoxelShapeBitSet.a(var0.a, var1.a, var5, var6, var7, var2);
        if (var5 instanceof VoxelShapeCubeMerger && var6 instanceof VoxelShapeCubeMerger && var7 instanceof VoxelShapeCubeMerger) {
            return new VoxelShapeCube(var8);
        }
        return new VoxelShapeArray((VoxelShapeDiscrete)var8, var5.a(), var6.a(), var7.a());
    }

    public static boolean c(VoxelShape var0, VoxelShape var1, OperatorBoolean var2) {
        if (var2.apply(false, false)) {
            throw SystemUtils.b(new IllegalArgumentException());
        }
        boolean var3 = var0.c();
        boolean var4 = var1.c();
        if (var3 || var4) {
            return var2.apply(!var3, !var4);
        }
        if (var0 == var1) {
            return var2.apply(true, true);
        }
        boolean var5 = var2.apply(true, false);
        boolean var6 = var2.apply(false, true);
        for (EnumDirection.EnumAxis var10 : EnumAxisCycle.d) {
            if (var0.c(var10) < var1.b(var10) - 1.0E-7) {
                return var5 || var6;
            }
            if (!(var1.c(var10) < var0.b(var10) - 1.0E-7)) continue;
            return var5 || var6;
        }
        VoxelShapeMerger var7 = VoxelShapes.a(1, var0.a(EnumDirection.EnumAxis.a), var1.a(EnumDirection.EnumAxis.a), var5, var6);
        VoxelShapeMerger var8 = VoxelShapes.a(var7.size() - 1, var0.a(EnumDirection.EnumAxis.b), var1.a(EnumDirection.EnumAxis.b), var5, var6);
        VoxelShapeMerger var9 = VoxelShapes.a((var7.size() - 1) * (var8.size() - 1), var0.a(EnumDirection.EnumAxis.c), var1.a(EnumDirection.EnumAxis.c), var5, var6);
        return VoxelShapes.a(var7, var8, var9, var0.a, var1.a, var2);
    }

    private static boolean a(VoxelShapeMerger var0, VoxelShapeMerger var1, VoxelShapeMerger var2, VoxelShapeDiscrete var3, VoxelShapeDiscrete var4, OperatorBoolean var52) {
        return !var0.a((var5, var62, var7) -> var1.a((var6, var72, var82) -> var2.a((var7, var8, var9) -> !var52.apply(var3.e(var5, var6, var7), var4.e(var62, var72, var8)))));
    }

    public static double a(EnumDirection.EnumAxis var0, AxisAlignedBB var1, Iterable<VoxelShape> var2, double var3) {
        for (VoxelShape var6 : var2) {
            if (Math.abs(var3) < 1.0E-7) {
                return 0.0;
            }
            var3 = var6.a(var0, var1, var3);
        }
        return var3;
    }

    public static boolean a(VoxelShape var0, VoxelShape var1, EnumDirection var2) {
        if (var0 == VoxelShapes.b() && var1 == VoxelShapes.b()) {
            return true;
        }
        if (var1.c()) {
            return false;
        }
        EnumDirection.EnumAxis var3 = var2.o();
        EnumDirection.EnumAxisDirection var4 = var2.f();
        VoxelShape var5 = var4 == EnumDirection.EnumAxisDirection.a ? var0 : var1;
        VoxelShape var6 = var4 == EnumDirection.EnumAxisDirection.a ? var1 : var0;
        OperatorBoolean var7 = var4 == EnumDirection.EnumAxisDirection.a ? OperatorBoolean.e : OperatorBoolean.c;
        return DoubleMath.fuzzyEquals((double)var5.c(var3), (double)1.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)var6.b(var3), (double)0.0, (double)1.0E-7) && !VoxelShapes.c((VoxelShape)new VoxelShapeSlice(var5, var3, var5.a.c(var3) - 1), new VoxelShapeSlice(var6, var3, 0), var7);
    }

    public static boolean b(VoxelShape var0, VoxelShape var1, EnumDirection var2) {
        VoxelShape var6;
        if (var0 == VoxelShapes.b() || var1 == VoxelShapes.b()) {
            return true;
        }
        EnumDirection.EnumAxis var3 = var2.o();
        EnumDirection.EnumAxisDirection var4 = var2.f();
        VoxelShape var5 = var4 == EnumDirection.EnumAxisDirection.a ? var0 : var1;
        VoxelShape voxelShape = var6 = var4 == EnumDirection.EnumAxisDirection.a ? var1 : var0;
        if (!DoubleMath.fuzzyEquals((double)var5.c(var3), (double)1.0, (double)1.0E-7)) {
            var5 = VoxelShapes.a();
        }
        if (!DoubleMath.fuzzyEquals((double)var6.b(var3), (double)0.0, (double)1.0E-7)) {
            var6 = VoxelShapes.a();
        }
        return !VoxelShapes.c(VoxelShapes.b(), VoxelShapes.b((VoxelShape)new VoxelShapeSlice(var5, var3, var5.a.c(var3) - 1), (VoxelShape)new VoxelShapeSlice(var6, var3, 0), OperatorBoolean.o), OperatorBoolean.e);
    }

    public static boolean b(VoxelShape var0, VoxelShape var1) {
        if (var0 == VoxelShapes.b() || var1 == VoxelShapes.b()) {
            return true;
        }
        if (var0.c() && var1.c()) {
            return false;
        }
        return !VoxelShapes.c(VoxelShapes.b(), VoxelShapes.b(var0, var1, OperatorBoolean.o), OperatorBoolean.e);
    }

    @VisibleForTesting
    protected static VoxelShapeMerger a(int var0, DoubleList var1, DoubleList var2, boolean var3, boolean var4) {
        long var7;
        int var5 = var1.size() - 1;
        int var6 = var2.size() - 1;
        if (var1 instanceof VoxelShapeCubePoint && var2 instanceof VoxelShapeCubePoint && (long)var0 * (var7 = VoxelShapes.a(var5, var6)) <= 256L) {
            return new VoxelShapeCubeMerger(var5, var6);
        }
        if (var1.getDouble(var5) < var2.getDouble(0) - 1.0E-7) {
            return new VoxelShapeMergerDisjoint(var1, var2, false);
        }
        if (var2.getDouble(var6) < var1.getDouble(0) - 1.0E-7) {
            return new VoxelShapeMergerDisjoint(var2, var1, true);
        }
        if (var5 == var6 && Objects.equals(var1, var2)) {
            return new VoxelShapeMergerIdentical(var1);
        }
        return new VoxelShapeMergerList(var1, var2, var3, var4);
    }

    public static VoxelShape a(VoxelShape var0, PointGroupO var1) {
        return VoxelShapes.a(var0, var1, e);
    }

    public static VoxelShape a(VoxelShape var0, PointGroupO var1, Vec3D var2) {
        if (var1 == PointGroupO.a) {
            return var0;
        }
        VoxelShapeDiscrete var3 = var0.a.a(var1);
        if (var0 instanceof VoxelShapeCube && e.equals(var2)) {
            return new VoxelShapeCube(var3);
        }
        EnumDirection.EnumAxis var4 = var1.d().a(EnumDirection.EnumAxis.a);
        EnumDirection.EnumAxis var5 = var1.d().a(EnumDirection.EnumAxis.b);
        EnumDirection.EnumAxis var6 = var1.d().a(EnumDirection.EnumAxis.c);
        DoubleList var7 = var0.a(var4);
        DoubleList var8 = var0.a(var5);
        DoubleList var9 = var0.a(var6);
        boolean var10 = var1.a(EnumDirection.EnumAxis.a);
        boolean var11 = var1.a(EnumDirection.EnumAxis.b);
        boolean var12 = var1.a(EnumDirection.EnumAxis.c);
        return new VoxelShapeArray(var3, VoxelShapes.a(var7, var10, var2.a(var4), var2.g), VoxelShapes.a(var8, var11, var2.a(var5), var2.h), VoxelShapes.a(var9, var12, var2.a(var6), var2.i));
    }

    @VisibleForTesting
    static DoubleList a(DoubleList var0, boolean var1, double var2, double var4) {
        if (!var1 && var2 == var4) {
            return var0;
        }
        int var6 = var0.size();
        DoubleArrayList var7 = new DoubleArrayList(var6);
        if (var1) {
            for (int var8 = var6 - 1; var8 >= 0; --var8) {
                var7.add(-(var0.getDouble(var8) - var2) + var4);
            }
        } else {
            for (int var8 = 0; var8 >= 0 && var8 < var6; ++var8) {
                var7.add(var0.getDouble(var8) - var2 + var4);
            }
        }
        return var7;
    }

    public static boolean c(VoxelShape var0, VoxelShape var1) {
        return !VoxelShapes.c(var0, var1, OperatorBoolean.g);
    }

    public static Map<EnumDirection.EnumAxis, VoxelShape> a(VoxelShape var0) {
        return VoxelShapes.a(var0, e);
    }

    public static Map<EnumDirection.EnumAxis, VoxelShape> a(VoxelShape var0, Vec3D var1) {
        return Maps.newEnumMap(Map.of(EnumDirection.EnumAxis.c, var0, EnumDirection.EnumAxis.a, VoxelShapes.a(var0, PointGroupO.ab, var1)));
    }

    public static Map<EnumDirection.EnumAxis, VoxelShape> b(VoxelShape var0) {
        return VoxelShapes.b(var0, e);
    }

    public static Map<EnumDirection.EnumAxis, VoxelShape> b(VoxelShape var0, Vec3D var1) {
        return Maps.newEnumMap(Map.of(EnumDirection.EnumAxis.c, var0, EnumDirection.EnumAxis.a, VoxelShapes.a(var0, PointGroupO.ab, var1), EnumDirection.EnumAxis.b, VoxelShapes.a(var0, PointGroupO.Y, var1)));
    }

    public static Map<EnumDirection, VoxelShape> c(VoxelShape var0) {
        return VoxelShapes.b(var0, PointGroupO.a, e);
    }

    public static Map<EnumDirection, VoxelShape> b(VoxelShape var0, PointGroupO var1) {
        return VoxelShapes.b(var0, var1, e);
    }

    public static Map<EnumDirection, VoxelShape> b(VoxelShape var0, PointGroupO var1, Vec3D var2) {
        return Maps.newEnumMap(Map.of(EnumDirection.c, VoxelShapes.a(var0, var1), EnumDirection.f, VoxelShapes.a(var0, PointGroupO.ab.a(var1), var2), EnumDirection.d, VoxelShapes.a(var0, PointGroupO.aa.a(var1), var2), EnumDirection.e, VoxelShapes.a(var0, PointGroupO.Z.a(var1), var2)));
    }

    public static Map<EnumDirection, VoxelShape> d(VoxelShape var0) {
        return VoxelShapes.c(var0, PointGroupO.a, e);
    }

    public static Map<EnumDirection, VoxelShape> c(VoxelShape var0, Vec3D var1) {
        return VoxelShapes.c(var0, PointGroupO.a, var1);
    }

    public static Map<EnumDirection, VoxelShape> c(VoxelShape var0, PointGroupO var1, Vec3D var2) {
        return Maps.newEnumMap(Map.of(EnumDirection.c, VoxelShapes.a(var0, var1), EnumDirection.f, VoxelShapes.a(var0, PointGroupO.ab.a(var1), var2), EnumDirection.d, VoxelShapes.a(var0, PointGroupO.aa.a(var1), var2), EnumDirection.e, VoxelShapes.a(var0, PointGroupO.Z.a(var1), var2), EnumDirection.b, VoxelShapes.a(var0, PointGroupO.W.a(var1), var2), EnumDirection.a, VoxelShapes.a(var0, PointGroupO.Y.a(var1), var2)));
    }

    public static Map<BlockPropertyAttachPosition, Map<EnumDirection, VoxelShape>> e(VoxelShape var0) {
        return VoxelShapes.c(var0, PointGroupO.a);
    }

    public static Map<BlockPropertyAttachPosition, Map<EnumDirection, VoxelShape>> c(VoxelShape var0, PointGroupO var1) {
        return Map.of(BlockPropertyAttachPosition.b, VoxelShapes.b(var0, var1), BlockPropertyAttachPosition.a, VoxelShapes.b(var0, PointGroupO.W.a(var1)), BlockPropertyAttachPosition.c, VoxelShapes.b(var0, PointGroupO.aa.a(PointGroupO.Y).a(var1)));
    }

    public static interface a {
        public void consume(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

