/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7;

import net.minecraft.world.level.levelgen.HeightMap;
import org.bukkit.HeightMap;

public final class CraftHeightMap {
    private CraftHeightMap() {
    }

    public static HeightMap.Type toNMS(HeightMap bukkitHeightMap) {
        switch (bukkitHeightMap) {
            case MOTION_BLOCKING_NO_LEAVES: {
                return HeightMap.Type.f;
            }
            case OCEAN_FLOOR: {
                return HeightMap.Type.d;
            }
            case OCEAN_FLOOR_WG: {
                return HeightMap.Type.c;
            }
            case WORLD_SURFACE: {
                return HeightMap.Type.b;
            }
            case WORLD_SURFACE_WG: {
                return HeightMap.Type.a;
            }
            case MOTION_BLOCKING: {
                return HeightMap.Type.e;
            }
        }
        throw new EnumConstantNotPresentException(HeightMap.Type.class, bukkitHeightMap.name());
    }

    public static HeightMap fromNMS(HeightMap.Type nmsHeightMapType) {
        switch (nmsHeightMapType) {
            case a: {
                return HeightMap.WORLD_SURFACE_WG;
            }
            case b: {
                return HeightMap.WORLD_SURFACE;
            }
            case c: {
                return HeightMap.OCEAN_FLOOR_WG;
            }
            case d: {
                return HeightMap.OCEAN_FLOOR;
            }
            case f: {
                return HeightMap.MOTION_BLOCKING_NO_LEAVES;
            }
            case e: {
                return HeightMap.MOTION_BLOCKING;
            }
        }
        throw new EnumConstantNotPresentException(HeightMap.class, nmsHeightMapType.name());
    }
}

