/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.context.ContextKey;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;

public class CraftLootTable
implements LootTable {
    private final net.minecraft.world.level.storage.loot.LootTable handle;
    private final NamespacedKey key;

    public static LootTable minecraftToBukkit(MinecraftKey minecraft) {
        return minecraft == null ? null : Bukkit.getLootTable((NamespacedKey)CraftNamespacedKey.fromMinecraft(minecraft));
    }

    public static LootTable minecraftToBukkit(ResourceKey<net.minecraft.world.level.storage.loot.LootTable> minecraft) {
        return minecraft == null ? null : Bukkit.getLootTable((NamespacedKey)CraftLootTable.minecraftToBukkitKey(minecraft));
    }

    public static NamespacedKey minecraftToBukkitKey(ResourceKey<net.minecraft.world.level.storage.loot.LootTable> minecraft) {
        return minecraft == null ? null : CraftNamespacedKey.fromMinecraft(minecraft.a());
    }

    public static ResourceKey<net.minecraft.world.level.storage.loot.LootTable> bukkitToMinecraft(LootTable table) {
        return table == null ? null : CraftLootTable.bukkitKeyToMinecraft(table.getKey());
    }

    public static ResourceKey<net.minecraft.world.level.storage.loot.LootTable> bukkitKeyToMinecraft(NamespacedKey key) {
        return key == null ? null : ResourceKey.a(Registries.bG, CraftNamespacedKey.toMinecraft(key));
    }

    public CraftLootTable(NamespacedKey key, net.minecraft.world.level.storage.loot.LootTable handle) {
        this.handle = handle;
        this.key = key;
    }

    public net.minecraft.world.level.storage.loot.LootTable getHandle() {
        return this.handle;
    }

    public Collection<ItemStack> populateLoot(Random random, LootContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        LootParams nmsContext = this.convertContext(context, random);
        ObjectArrayList<net.minecraft.world.item.ItemStack> nmsItems = this.handle.a(nmsContext);
        ArrayList<ItemStack> bukkit = new ArrayList<ItemStack>(nmsItems.size());
        for (net.minecraft.world.item.ItemStack item : nmsItems) {
            if (item.f()) continue;
            bukkit.add(CraftItemStack.asBukkitCopy(item));
        }
        return bukkit;
    }

    public void fillInventory(Inventory inventory, Random random, LootContext context) {
        Preconditions.checkArgument((inventory != null ? 1 : 0) != 0, (Object)"Inventory cannot be null");
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        LootParams nmsContext = this.convertContext(context, random);
        CraftInventory craftInventory = (CraftInventory)inventory;
        IInventory handle = craftInventory.getInventory();
        this.getHandle().fillInventory(handle, nmsContext, random.nextLong(), true);
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    private LootParams convertContext(LootContext context, Random random) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        Location loc = context.getLocation();
        Preconditions.checkArgument((loc.getWorld() != null ? 1 : 0) != 0, (Object)"LootContext.getLocation#getWorld cannot be null");
        WorldServer handle = ((CraftWorld)loc.getWorld()).getHandle();
        LootParams.a builder = new LootParams.a(handle);
        if (random != null) {
            // empty if block
        }
        this.setMaybe(builder, LootContextParameters.h, CraftLocation.toVec3D(loc));
        if (this.getHandle() != net.minecraft.world.level.storage.loot.LootTable.f) {
            if (context.getLootedEntity() != null) {
                net.minecraft.world.entity.Entity nmsLootedEntity = ((CraftEntity)context.getLootedEntity()).getHandle();
                this.setMaybe(builder, LootContextParameters.a, nmsLootedEntity);
                this.setMaybe(builder, LootContextParameters.e, handle.as().p());
                this.setMaybe(builder, LootContextParameters.h, nmsLootedEntity.dI());
            }
            if (context.getKiller() != null) {
                EntityHuman nmsKiller = ((CraftHumanEntity)context.getKiller()).getHandle();
                this.setMaybe(builder, LootContextParameters.f, nmsKiller);
                this.setMaybe(builder, LootContextParameters.e, handle.as().a(nmsKiller));
                this.setMaybe(builder, LootContextParameters.d, nmsKiller);
                this.setMaybe(builder, LootContextParameters.k, nmsKiller.gb());
            }
        }
        ContextKeySet.a nmsBuilder = new ContextKeySet.a();
        for (ContextKey<?> param : this.getHandle().a().a()) {
            nmsBuilder.a(param);
        }
        for (ContextKey<?> param : this.getHandle().a().b()) {
            if (this.getHandle().a().a().contains(param)) continue;
            nmsBuilder.b(param);
        }
        return builder.a(this.getHandle().a());
    }

    private <T> void setMaybe(LootParams.a builder, ContextKey<T> param, T value) {
        if (this.getHandle().a().a().contains(param) || this.getHandle().a().b().contains(param)) {
            builder.a(param, value);
        }
    }

    public static LootContext convertContext(LootTableInfo info) {
        CraftEntity killer;
        Vec3D position = info.c(LootContextParameters.h);
        if (position == null) {
            position = info.c(LootContextParameters.a).dI();
        }
        Location location = CraftLocation.toBukkit(position, (World)info.d().getWorld());
        LootContext.Builder contextBuilder = new LootContext.Builder(location);
        if (info.a(LootContextParameters.f) && (killer = info.c(LootContextParameters.f).getBukkitEntity()) instanceof CraftHumanEntity) {
            contextBuilder.killer((HumanEntity)((CraftHumanEntity)killer));
        }
        if (info.a(LootContextParameters.a)) {
            contextBuilder.lootedEntity((Entity)info.c(LootContextParameters.a).getBukkitEntity());
        }
        contextBuilder.luck(info.c());
        return contextBuilder.build();
    }

    public String toString() {
        return this.getKey().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LootTable)) {
            return false;
        }
        LootTable table = (LootTable)obj;
        return table.getKey().equals((Object)this.getKey());
    }
}

