/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.criterion.CriterionConditionItem;
import net.minecraft.advancements.criterion.CriterionConditionValue;
import net.minecraft.advancements.criterion.DataComponentMatchers;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ChestLock;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Beacon;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftBeacon
extends CraftBlockEntityState<TileEntityBeacon>
implements Beacon {
    public CraftBeacon(World world, TileEntityBeacon tileEntity) {
        super(world, tileEntity);
    }

    protected CraftBeacon(CraftBeacon state, Location location) {
        super(state, location);
    }

    public Collection<LivingEntity> getEntitiesInRange() {
        this.ensureNoWorldGeneration();
        TileEntity tileEntity = this.getTileEntityFromWorld();
        if (tileEntity instanceof TileEntityBeacon) {
            TileEntityBeacon beacon = (TileEntityBeacon)tileEntity;
            List nms = TileEntityBeacon.getHumansInRange(beacon.j(), beacon.aD_(), beacon.q);
            ArrayList<LivingEntity> bukkit = new ArrayList<LivingEntity>(nms.size());
            for (EntityHuman human : nms) {
                bukkit.add(human.getBukkitEntity());
            }
            return bukkit;
        }
        return new ArrayList<LivingEntity>();
    }

    public int getTier() {
        return ((TileEntityBeacon)this.getSnapshot()).q;
    }

    public PotionEffect getPrimaryEffect() {
        return ((TileEntityBeacon)this.getSnapshot()).getPrimaryEffect();
    }

    public void setPrimaryEffect(PotionEffectType effect) {
        ((TileEntityBeacon)this.getSnapshot()).s = effect != null ? CraftPotionEffectType.bukkitToMinecraftHolder(effect) : null;
    }

    public PotionEffect getSecondaryEffect() {
        return ((TileEntityBeacon)this.getSnapshot()).getSecondaryEffect();
    }

    public void setSecondaryEffect(PotionEffectType effect) {
        ((TileEntityBeacon)this.getSnapshot()).t = effect != null ? CraftPotionEffectType.bukkitToMinecraftHolder(effect) : null;
    }

    public String getCustomName() {
        TileEntityBeacon beacon = (TileEntityBeacon)this.getSnapshot();
        return beacon.u != null ? CraftChatMessage.fromComponent(beacon.u) : null;
    }

    public void setCustomName(String name) {
        ((TileEntityBeacon)this.getSnapshot()).a(CraftChatMessage.fromStringOrNull(name));
    }

    public boolean isLocked() {
        return ((TileEntityBeacon)this.getSnapshot()).v != ChestLock.a;
    }

    public String getLock() {
        Optional<IChatBaseComponent> customName = ((TileEntityBeacon)this.getSnapshot()).v.a().c().b().d().a(DataComponents.h);
        return customName != null ? customName.map(CraftChatMessage::fromComponent).orElse("") : "";
    }

    public void setLock(String key) {
        if (key == null) {
            ((TileEntityBeacon)this.getSnapshot()).v = ChestLock.a;
        } else {
            DataComponentExactPredicate predicate = DataComponentExactPredicate.a().a(DataComponents.h, CraftChatMessage.fromStringOrNull(key)).a();
            ((TileEntityBeacon)this.getSnapshot()).v = new ChestLock(new CriterionConditionItem(Optional.empty(), CriterionConditionValue.IntegerRange.c, new DataComponentMatchers(predicate, Collections.emptyMap())));
        }
    }

    public void setLockItem(ItemStack key) {
        ((TileEntityBeacon)this.getSnapshot()).v = key == null ? ChestLock.a : new ChestLock(CraftItemStack.asCriterionConditionItem(key));
    }

    @Override
    public CraftBeacon copy() {
        return new CraftBeacon(this, null);
    }

    @Override
    public CraftBeacon copy(Location location) {
        return new CraftBeacon(this, location);
    }
}

