/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import java.util.Collections;
import java.util.Optional;
import net.minecraft.advancements.criterion.CriterionConditionItem;
import net.minecraft.advancements.criterion.CriterionConditionValue;
import net.minecraft.advancements.criterion.DataComponentMatchers;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ChestLock;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Container;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.inventory.ItemStack;

public abstract class CraftContainer<T extends TileEntityContainer>
extends CraftBlockEntityState<T>
implements Container {
    public CraftContainer(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CraftContainer(CraftContainer<T> state, Location location) {
        super(state, location);
    }

    public boolean isLocked() {
        return ((TileEntityContainer)this.getSnapshot()).d != ChestLock.a;
    }

    public String getLock() {
        Optional<IChatBaseComponent> customName = ((TileEntityContainer)this.getSnapshot()).d.a().c().b().d().a(DataComponents.h);
        return customName != null ? customName.map(CraftChatMessage::fromComponent).orElse("") : "";
    }

    public void setLock(String key) {
        if (key == null) {
            ((TileEntityContainer)this.getSnapshot()).d = ChestLock.a;
        } else {
            DataComponentExactPredicate predicate = DataComponentExactPredicate.a().a(DataComponents.h, CraftChatMessage.fromStringOrNull(key)).a();
            ((TileEntityContainer)this.getSnapshot()).d = new ChestLock(new CriterionConditionItem(Optional.empty(), CriterionConditionValue.IntegerRange.c, new DataComponentMatchers(predicate, Collections.emptyMap())));
        }
    }

    public void setLockItem(ItemStack key) {
        ((TileEntityContainer)this.getSnapshot()).d = key == null ? ChestLock.a : new ChestLock(CraftItemStack.asCriterionConditionItem(key));
    }

    public String getCustomName() {
        TileEntityContainer container = (TileEntityContainer)this.getSnapshot();
        return container.e != null ? CraftChatMessage.fromComponent(container.as()) : null;
    }

    public void setCustomName(String name) {
        ((TileEntityContainer)this.getSnapshot()).e = CraftChatMessage.fromStringOrNull(name);
    }

    @Override
    protected void applyTo(T container) {
        super.applyTo(container);
        if (((TileEntityContainer)this.getSnapshot()).e == null) {
            ((TileEntityContainer)container).e = null;
        }
    }

    @Override
    public abstract CraftContainer<T> copy();

    @Override
    public abstract CraftContainer<T> copy(Location var1);
}

