/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Furnace;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftContainer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Recipe;

public abstract class CraftFurnace<T extends TileEntityFurnace>
extends CraftContainer<T>
implements Furnace {
    public CraftFurnace(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CraftFurnace(CraftFurnace<T> state, Location location) {
        super(state, location);
    }

    public FurnaceInventory getSnapshotInventory() {
        return new CraftInventoryFurnace((TileEntityFurnace)this.getSnapshot());
    }

    public FurnaceInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryFurnace((TileEntityFurnace)this.getTileEntity());
    }

    public short getBurnTime() {
        return (short)((TileEntityFurnace)this.getSnapshot()).y;
    }

    public void setBurnTime(short burnTime) {
        ((TileEntityFurnace)this.getSnapshot()).y = burnTime;
        this.data = (IBlockData)this.data.b(BlockFurnace.b, burnTime > 0);
    }

    public short getCookTime() {
        return (short)((TileEntityFurnace)this.getSnapshot()).A;
    }

    public void setCookTime(short cookTime) {
        ((TileEntityFurnace)this.getSnapshot()).A = cookTime;
    }

    public int getCookTimeTotal() {
        return ((TileEntityFurnace)this.getSnapshot()).B;
    }

    public void setCookTimeTotal(int cookTimeTotal) {
        ((TileEntityFurnace)this.getSnapshot()).B = cookTimeTotal;
    }

    public Map<CookingRecipe<?>, Integer> getRecipesUsed() {
        ImmutableMap.Builder recipesUsed = ImmutableMap.builder();
        ((TileEntityFurnace)this.getSnapshot()).C.reference2IntEntrySet().fastForEach(entrySet -> {
            Recipe recipe = Bukkit.getRecipe((NamespacedKey)CraftNamespacedKey.fromMinecraft(((ResourceKey)entrySet.getKey()).a()));
            if (recipe instanceof CookingRecipe) {
                CookingRecipe cookingRecipe = (CookingRecipe)recipe;
                recipesUsed.put((Object)cookingRecipe, (Object)entrySet.getValue());
            }
        });
        return recipesUsed.build();
    }

    @Override
    public abstract CraftFurnace<T> copy();

    @Override
    public abstract CraftFurnace<T> copy(Location var1);
}

