/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.BigDripleafBlock;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockBamboo;
import net.minecraft.world.level.block.BlockBanner;
import net.minecraft.world.level.block.BlockBannerWall;
import net.minecraft.world.level.block.BlockBarrel;
import net.minecraft.world.level.block.BlockBarrier;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockBeetroot;
import net.minecraft.world.level.block.BlockBell;
import net.minecraft.world.level.block.BlockBlastFurnace;
import net.minecraft.world.level.block.BlockBrewingStand;
import net.minecraft.world.level.block.BlockBubbleColumn;
import net.minecraft.world.level.block.BlockButtonAbstract;
import net.minecraft.world.level.block.BlockCactus;
import net.minecraft.world.level.block.BlockCake;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockCarrots;
import net.minecraft.world.level.block.BlockChain;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockChestTrapped;
import net.minecraft.world.level.block.BlockChorusFlower;
import net.minecraft.world.level.block.BlockChorusFruit;
import net.minecraft.world.level.block.BlockCobbleWall;
import net.minecraft.world.level.block.BlockCocoa;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.BlockComposter;
import net.minecraft.world.level.block.BlockConduit;
import net.minecraft.world.level.block.BlockCoralDead;
import net.minecraft.world.level.block.BlockCoralFan;
import net.minecraft.world.level.block.BlockCoralFanAbstract;
import net.minecraft.world.level.block.BlockCoralFanWall;
import net.minecraft.world.level.block.BlockCoralFanWallAbstract;
import net.minecraft.world.level.block.BlockCoralPlant;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockDaylightDetector;
import net.minecraft.world.level.block.BlockDirtSnow;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockDropper;
import net.minecraft.world.level.block.BlockEndRod;
import net.minecraft.world.level.block.BlockEnderChest;
import net.minecraft.world.level.block.BlockEnderPortalFrame;
import net.minecraft.world.level.block.BlockFence;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.BlockFloorSign;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.BlockFurnaceFurace;
import net.minecraft.world.level.block.BlockGlazedTerracotta;
import net.minecraft.world.level.block.BlockGrass;
import net.minecraft.world.level.block.BlockGrindstone;
import net.minecraft.world.level.block.BlockHay;
import net.minecraft.world.level.block.BlockHopper;
import net.minecraft.world.level.block.BlockHugeMushroom;
import net.minecraft.world.level.block.BlockIceFrost;
import net.minecraft.world.level.block.BlockIronBars;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.BlockJukeBox;
import net.minecraft.world.level.block.BlockKelp;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockLantern;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.BlockLever;
import net.minecraft.world.level.block.BlockLoom;
import net.minecraft.world.level.block.BlockMinecartDetector;
import net.minecraft.world.level.block.BlockMinecartTrack;
import net.minecraft.world.level.block.BlockMycel;
import net.minecraft.world.level.block.BlockNetherWart;
import net.minecraft.world.level.block.BlockNote;
import net.minecraft.world.level.block.BlockObserver;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.BlockPotatoes;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.BlockPressurePlateBinary;
import net.minecraft.world.level.block.BlockPressurePlateWeighted;
import net.minecraft.world.level.block.BlockPumpkinCarved;
import net.minecraft.world.level.block.BlockRedstoneComparator;
import net.minecraft.world.level.block.BlockRedstoneLamp;
import net.minecraft.world.level.block.BlockRedstoneOre;
import net.minecraft.world.level.block.BlockRedstoneTorch;
import net.minecraft.world.level.block.BlockRedstoneTorchWall;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.BlockReed;
import net.minecraft.world.level.block.BlockRepeater;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockScaffolding;
import net.minecraft.world.level.block.BlockSeaPickle;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.BlockSkullPlayer;
import net.minecraft.world.level.block.BlockSkullPlayerWall;
import net.minecraft.world.level.block.BlockSkullWall;
import net.minecraft.world.level.block.BlockSmoker;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.BlockSoil;
import net.minecraft.world.level.block.BlockStainedGlassPane;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockStemAttached;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.BlockStonecutter;
import net.minecraft.world.level.block.BlockStructure;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.BlockTallPlantFlower;
import net.minecraft.world.level.block.BlockTarget;
import net.minecraft.world.level.block.BlockTorchWall;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.BlockTripwire;
import net.minecraft.world.level.block.BlockTripwireHook;
import net.minecraft.world.level.block.BlockTurtleEgg;
import net.minecraft.world.level.block.BlockTwistingVines;
import net.minecraft.world.level.block.BlockVine;
import net.minecraft.world.level.block.BlockWallSign;
import net.minecraft.world.level.block.BlockWeepingVines;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.BlockWitherSkullWall;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.CalibratedSculkSensorBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.CopperBulbBlock;
import net.minecraft.world.level.block.CopperChestBlock;
import net.minecraft.world.level.block.CopperGolemStatueBlock;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.DriedGhastBlock;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.FlowerBedBlock;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.HangingMossBlock;
import net.minecraft.world.level.block.HangingRootsBlock;
import net.minecraft.world.level.block.HeavyCoreBlock;
import net.minecraft.world.level.block.InfestedRotatedPillarBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LeafLitterBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.MangroveLeavesBlock;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PiglinWallSkullBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.SculkCatalystBlock;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.ShelfBlock;
import net.minecraft.world.level.block.SmallDripleafBlock;
import net.minecraft.world.level.block.SnifferEggBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TestBlock;
import net.minecraft.world.level.block.TintedParticleLeavesBlock;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.UntintedParticleLeavesBlock;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WaterloggedTransparentBlock;
import net.minecraft.world.level.block.WeatheringCopperBarsBlock;
import net.minecraft.world.level.block.WeatheringCopperBulbBlock;
import net.minecraft.world.level.block.WeatheringCopperChainBlock;
import net.minecraft.world.level.block.WeatheringCopperChestBlock;
import net.minecraft.world.level.block.WeatheringCopperDoorBlock;
import net.minecraft.world.level.block.WeatheringCopperGolemStatueBlock;
import net.minecraft.world.level.block.WeatheringCopperGrateBlock;
import net.minecraft.world.level.block.WeatheringCopperSlabBlock;
import net.minecraft.world.level.block.WeatheringCopperStairBlock;
import net.minecraft.world.level.block.WeatheringCopperTrapDoorBlock;
import net.minecraft.world.level.block.WeatheringLanternBlock;
import net.minecraft.world.level.block.WeatheringLightningRodBlock;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundGroup;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BlockSupport;
import org.bukkit.block.BlockType;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftSoundGroup;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockSupport;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockStateEnum;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftAmethystCluster;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftAnvil;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBamboo;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBanner;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBannerWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBarrel;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBarrier;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBed;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBeehive;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBeetroot;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBell;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBigDripleaf;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBigDripleafStem;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBrushable;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBubbleColumn;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftButtonAbstract;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCactus;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCake;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCalibratedSculkSensor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCampfire;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCandle;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCandleCake;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCarrots;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCaveVines;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCaveVinesPlant;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCeilingHangingSign;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftChain;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftChest;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftChestTrapped;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftChiseledBookShelf;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftChorusFlower;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftChorusFruit;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCobbleWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCocoa;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCommand;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftComposter;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftConduit;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCopperBulb;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCopperChest;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCopperGolemStatue;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCoralDead;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCoralFan;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCoralFanAbstract;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCoralFanWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCoralFanWallAbstract;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCoralPlant;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCrafter;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCreakingHeart;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCrops;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDecoratedPot;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDirtSnow;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDispenser;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDoor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDriedGhast;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDropper;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftEndRod;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftEnderChest;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftEnderPortalFrame;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFence;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFenceGate;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFire;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFloorSign;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFlowerBed;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFluids;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFurnaceFurace;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftGlazedTerracotta;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftGlowLichen;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftGrass;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftGrindstone;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftHangingMoss;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftHangingRoots;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftHay;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftHeavyCore;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftHopper;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftHugeMushroom;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftIceFrost;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftInfestedRotatedPillar;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftIronBars;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftJigsaw;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftJukeBox;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftKelp;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLadder;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLantern;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLayeredCauldron;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLeafLitter;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLectern;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLever;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLight;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLightningRod;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLoom;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMangroveLeaves;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMangrovePropagule;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMangroveRoots;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMinecartDetector;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMinecartTrack;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMossyCarpet;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMultiface;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMycel;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftNetherWart;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftNote;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftObserver;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPiglinWallSkull;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPiston;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPistonExtension;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPistonMoving;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPitcherCrop;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPointedDripstone;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPortal;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPotatoes;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPoweredRail;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPressurePlateBinary;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPressurePlateWeighted;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPumpkinCarved;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRedstoneComparator;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRedstoneLamp;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRedstoneOre;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRedstoneTorch;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRedstoneTorchWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRedstoneWire;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftReed;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRepeater;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRespawnAnchor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRotatable;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSapling;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftScaffolding;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSculkCatalyst;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSculkSensor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSculkShrieker;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSculkVein;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSeaPickle;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftShelf;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSkullPlayer;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSkullPlayerWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSkullWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSmallDripleaf;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSmoker;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSnifferEgg;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSnow;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSoil;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStainedGlassPane;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStairs;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStem;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStemAttached;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStepAbstract;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStonecutter;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSweetBerryBush;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTNT;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTallPlant;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTallPlantFlower;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTallSeagrass;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTarget;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTest;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTintedParticleLeaves;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTorchWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTorchflowerCrop;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTrapdoor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTrialSpawner;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTripwire;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTripwireHook;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTurtleEgg;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTwistingVines;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftUntintedParticleLeaves;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftVault;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftVine;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWallHangingSign;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWallSign;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWaterloggedTransparent;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperBars;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperBulb;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperChain;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperChest;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperDoor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperGolemStatue;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperGrate;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperSlab;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperStair;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperTrapDoor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringLantern;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringLightningRod;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeepingVines;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWitherSkullWall;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftBlockData
implements BlockData {
    private IBlockData state;
    private Map<IBlockState<?>, Comparable<?>> parsedStates;
    private static final Map<Class<? extends Block>, Function<IBlockData, CraftBlockData>> MAP = new HashMap<Class<? extends Block>, Function<IBlockData, CraftBlockData>>();

    protected CraftBlockData() {
        throw new AssertionError((Object)"Template Constructor");
    }

    protected CraftBlockData(IBlockData state) {
        this.state = state;
    }

    public Material getMaterial() {
        return CraftBlockType.minecraftToBukkit(this.state.b());
    }

    public IBlockData getState() {
        return this.state;
    }

    protected <N extends Enum<N>, B extends Enum<B>> B get(CraftBlockStateEnum<N, B> nms) {
        return nms.toBukkit((Enum)this.state.c(nms.nms()));
    }

    protected <N extends Enum<N>, B extends Enum<B>> Set<B> getValues(CraftBlockStateEnum<N, B> nms) {
        return nms.getValues();
    }

    protected <N extends Enum<N>, B extends Enum<B>> void set(CraftBlockStateEnum<N, B> nms, B bukkit) {
        this.parsedStates = null;
        this.state = (IBlockData)this.state.b(nms.nms(), nms.toNMS(bukkit));
    }

    public BlockData merge(BlockData data) {
        CraftBlockData craft = (CraftBlockData)data;
        Preconditions.checkArgument((craft.parsedStates != null ? 1 : 0) != 0, (Object)"Data not created via string parsing");
        Preconditions.checkArgument((this.state.b() == craft.state.b() ? 1 : 0) != 0, (String)"States have different types (got %s, expected %s)", (Object)data, (Object)this);
        CraftBlockData clone = (CraftBlockData)this.clone();
        clone.parsedStates = null;
        for (IBlockState<?> parsed : craft.parsedStates.keySet()) {
            clone.state = (IBlockData)clone.state.b(parsed, craft.state.c(parsed));
        }
        return clone;
    }

    public boolean matches(BlockData data) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof CraftBlockData)) {
            return false;
        }
        CraftBlockData craft = (CraftBlockData)data;
        if (this.state.b() != craft.state.b()) {
            return false;
        }
        boolean exactMatch = this.equals(data);
        if (!exactMatch && craft.parsedStates != null) {
            return this.merge(data).equals((Object)this);
        }
        return exactMatch;
    }

    protected <T extends Comparable<T>> T get(IBlockState<T> ibs) {
        return this.state.c(ibs);
    }

    public <T extends Comparable<T>, V extends T> void set(IBlockState<T> ibs, V v2) {
        this.parsedStates = null;
        this.state = (IBlockData)this.state.b(ibs, v2);
    }

    public String getAsString() {
        return this.toString(this.state.G());
    }

    public String getAsString(boolean hideUnspecified) {
        return hideUnspecified && this.parsedStates != null ? this.toString(this.parsedStates) : this.getAsString();
    }

    public BlockData clone() {
        try {
            return (BlockData)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError("Clone not supported", ex);
        }
    }

    public String toString() {
        return "CraftBlockData{" + this.getAsString() + "}";
    }

    public String toString(Map<IBlockState<?>, Comparable<?>> states) {
        StringBuilder stateString = new StringBuilder(BuiltInRegistries.e.b(this.state.b()).toString());
        if (!states.isEmpty()) {
            stateString.append('[');
            stateString.append(states.entrySet().stream().map(IBlockDataHolder.a).collect(Collectors.joining(",")));
            stateString.append(']');
        }
        return stateString.toString();
    }

    public Map<String, String> toStates(boolean hideUnspecified) {
        return hideUnspecified && this.parsedStates != null ? CraftBlockData.toStates(this.parsedStates) : CraftBlockData.toStates(this.state.G());
    }

    private static Map<String, String> toStates(Map<IBlockState<?>, Comparable<?>> states) {
        HashMap<String, String> compound = new HashMap<String, String>();
        for (Map.Entry<IBlockState<?>, Comparable<?>> entry : states.entrySet()) {
            IBlockState<?> iblockstate = entry.getKey();
            compound.put(iblockstate.f(), iblockstate.b(entry.getValue()));
        }
        return compound;
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftBlockData && this.state.equals(((CraftBlockData)obj).state);
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    protected static BlockStateBoolean getBoolean(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static BlockStateBoolean getBoolean(String name, boolean optional) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static <B extends Enum<B>> CraftBlockStateEnum<?, B> getEnum(String name, Class<? extends Enum<B>> bukkit) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static BlockStateInteger getInteger(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static BlockStateBoolean getBoolean(Class<? extends Block> block, String name) {
        return (BlockStateBoolean)CraftBlockData.getState(block, name, false);
    }

    protected static BlockStateBoolean getBoolean(Class<? extends Block> block, String name, boolean optional) {
        return (BlockStateBoolean)CraftBlockData.getState(block, name, optional);
    }

    protected static <B extends Enum<B>> CraftBlockStateEnum<?, B> getEnum(Class<? extends Block> block, String name, Class<B> bukkit) {
        return new CraftBlockStateEnum((BlockStateEnum)CraftBlockData.getState(block, name, false), bukkit);
    }

    protected static BlockStateInteger getInteger(Class<? extends Block> block, String name) {
        return (BlockStateInteger)CraftBlockData.getState(block, name, false);
    }

    private static IBlockState<?> getState(Class<? extends Block> block, String name, boolean optional) {
        IBlockState<?> state = null;
        for (Block instance : BuiltInRegistries.e) {
            if (instance.getClass() != block) continue;
            if (state == null) {
                state = instance.l().a(name);
                continue;
            }
            IBlockState<?> newState = instance.l().a(name);
            Preconditions.checkState((state == newState ? 1 : 0) != 0, (String)"State mistmatch %s,%s", state, newState);
        }
        Preconditions.checkState((optional || state != null ? 1 : 0) != 0, (String)"Null state for %s,%s", block, (Object)name);
        return state;
    }

    protected static int getMin(BlockStateInteger state) {
        return state.b;
    }

    protected static int getMax(BlockStateInteger state) {
        return state.c;
    }

    private static void register(Class<? extends Block> nms, Function<IBlockData, CraftBlockData> bukkit) {
        Preconditions.checkState((MAP.put(nms, bukkit) == null ? 1 : 0) != 0, (String)"Duplicate mapping %s->%s", nms, bukkit);
    }

    public static CraftBlockData newData(BlockType blockType, String data) {
        IBlockData blockData;
        Block block = blockType == null ? null : (Block)((CraftBlockType)blockType).getHandle();
        Map<IBlockState<?>, Comparable<?>> parsed = null;
        if (data != null) {
            try {
                if (block != null) {
                    data = String.valueOf(BuiltInRegistries.e.b(block)) + (String)data;
                }
                StringReader reader = new StringReader((String)data);
                ArgumentBlock.a arg = ArgumentBlock.a(CraftRegistry.getMinecraftRegistry(Registries.i), reader, false);
                Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (Object)("Spurious trailing data: " + (String)data));
                blockData = arg.a();
                parsed = arg.b();
            }
            catch (CommandSyntaxException ex) {
                throw new IllegalArgumentException("Could not parse data: " + (String)data, ex);
            }
        } else {
            blockData = block.m();
        }
        CraftBlockData craft = CraftBlockData.fromData(blockData);
        craft.parsedStates = parsed;
        return craft;
    }

    public static CraftBlockData fromData(IBlockData data) {
        return (CraftBlockData)MAP.getOrDefault(data.b().getClass(), (Function<IBlockData, CraftBlockData>)((Function)CraftBlockData::new)).apply((Object)data);
    }

    public SoundGroup getSoundGroup() {
        return CraftSoundGroup.getSoundGroup(this.state.A());
    }

    public int getLightEmission() {
        return this.state.k();
    }

    public boolean isOccluding() {
        return this.state.t();
    }

    public boolean requiresCorrectToolForDrops() {
        return this.state.C();
    }

    public boolean isPreferredTool(ItemStack tool) {
        Preconditions.checkArgument((tool != null ? 1 : 0) != 0, (Object)"tool must not be null");
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(tool);
        return CraftBlockData.isPreferredTool(this.state, nms);
    }

    public static boolean isPreferredTool(IBlockData iblockdata, net.minecraft.world.item.ItemStack nmsItem) {
        return !iblockdata.C() || nmsItem.b(iblockdata);
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)this.state.r().ordinal());
    }

    public boolean isSupported(org.bukkit.block.Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
        CraftBlock craftBlock = (CraftBlock)block;
        return this.state.a((IWorldReader)craftBlock.getCraftWorld().getHandle(), craftBlock.getPosition());
    }

    public boolean isSupported(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location must not be null");
        CraftWorld world = (CraftWorld)location.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"location must not have a null world");
        BlockPosition position = CraftLocation.toBlockPosition(location);
        return this.state.a((IWorldReader)world.getHandle(), position);
    }

    public boolean isFaceSturdy(BlockFace face, BlockSupport support) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        Preconditions.checkArgument((support != null ? 1 : 0) != 0, (Object)"support must not be null");
        return this.state.a((IBlockAccess)BlockAccessAir.a, BlockPosition.c, CraftBlock.blockFaceToNotch(face), CraftBlockSupport.toNMS(support));
    }

    public Color getMapColor() {
        return Color.fromRGB((int)this.state.a(null, null).ak);
    }

    public Material getPlacementMaterial() {
        return CraftItemType.minecraftToBukkit(this.state.b().h());
    }

    public void rotate(StructureRotation rotation) {
        this.state = this.state.a(EnumBlockRotation.valueOf(rotation.name()));
    }

    public void mirror(Mirror mirror) {
        this.state = this.state.a(EnumBlockMirror.valueOf(mirror.name()));
    }

    public void copyTo(BlockData blockData) {
        CraftBlockData other = (CraftBlockData)blockData;
        IBlockData nms = other.state;
        for (IBlockState<?> property : this.state.b().l().d()) {
            if (!nms.b(property)) continue;
            nms = this.copyProperty(this.state, nms, property);
        }
        other.state = nms;
    }

    private <T extends Comparable<T>> IBlockData copyProperty(IBlockData source, IBlockData target, IBlockState<T> property) {
        return (IBlockData)target.b(property, source.c(property));
    }

    @NotNull
    public BlockState createBlockState() {
        return CraftBlockStates.getBlockState(this.state, null);
    }

    static {
        CraftBlockData.register(AmethystClusterBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftAmethystCluster::new));
        CraftBlockData.register(BigDripleafBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBigDripleaf::new));
        CraftBlockData.register(BigDripleafStemBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBigDripleafStem::new));
        CraftBlockData.register(BlockAnvil.class, (Function<IBlockData, CraftBlockData>)((Function)CraftAnvil::new));
        CraftBlockData.register(BlockBamboo.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBamboo::new));
        CraftBlockData.register(BlockBanner.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBanner::new));
        CraftBlockData.register(BlockBannerWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBannerWall::new));
        CraftBlockData.register(BlockBarrel.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBarrel::new));
        CraftBlockData.register(BlockBarrier.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBarrier::new));
        CraftBlockData.register(BlockBed.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBed::new));
        CraftBlockData.register(BlockBeehive.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBeehive::new));
        CraftBlockData.register(BlockBeetroot.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBeetroot::new));
        CraftBlockData.register(BlockBell.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBell::new));
        CraftBlockData.register(BlockBlastFurnace.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBlastFurnace::new));
        CraftBlockData.register(BlockBrewingStand.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBrewingStand::new));
        CraftBlockData.register(BlockBubbleColumn.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBubbleColumn::new));
        CraftBlockData.register(BlockButtonAbstract.class, (Function<IBlockData, CraftBlockData>)((Function)CraftButtonAbstract::new));
        CraftBlockData.register(BlockCactus.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCactus::new));
        CraftBlockData.register(BlockCake.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCake::new));
        CraftBlockData.register(BlockCampfire.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCampfire::new));
        CraftBlockData.register(BlockCarrots.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCarrots::new));
        CraftBlockData.register(BlockChain.class, (Function<IBlockData, CraftBlockData>)((Function)CraftChain::new));
        CraftBlockData.register(BlockChest.class, (Function<IBlockData, CraftBlockData>)((Function)CraftChest::new));
        CraftBlockData.register(BlockChestTrapped.class, (Function<IBlockData, CraftBlockData>)((Function)CraftChestTrapped::new));
        CraftBlockData.register(BlockChorusFlower.class, (Function<IBlockData, CraftBlockData>)((Function)CraftChorusFlower::new));
        CraftBlockData.register(BlockChorusFruit.class, (Function<IBlockData, CraftBlockData>)((Function)CraftChorusFruit::new));
        CraftBlockData.register(BlockCobbleWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCobbleWall::new));
        CraftBlockData.register(BlockCocoa.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCocoa::new));
        CraftBlockData.register(BlockCommand.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCommand::new));
        CraftBlockData.register(BlockComposter.class, (Function<IBlockData, CraftBlockData>)((Function)CraftComposter::new));
        CraftBlockData.register(BlockConduit.class, (Function<IBlockData, CraftBlockData>)((Function)CraftConduit::new));
        CraftBlockData.register(BlockCoralDead.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCoralDead::new));
        CraftBlockData.register(BlockCoralFan.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCoralFan::new));
        CraftBlockData.register(BlockCoralFanAbstract.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCoralFanAbstract::new));
        CraftBlockData.register(BlockCoralFanWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCoralFanWall::new));
        CraftBlockData.register(BlockCoralFanWallAbstract.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCoralFanWallAbstract::new));
        CraftBlockData.register(BlockCoralPlant.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCoralPlant::new));
        CraftBlockData.register(BlockCrops.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCrops::new));
        CraftBlockData.register(BlockDaylightDetector.class, (Function<IBlockData, CraftBlockData>)((Function)CraftDaylightDetector::new));
        CraftBlockData.register(BlockDirtSnow.class, (Function<IBlockData, CraftBlockData>)((Function)CraftDirtSnow::new));
        CraftBlockData.register(BlockDispenser.class, (Function<IBlockData, CraftBlockData>)((Function)CraftDispenser::new));
        CraftBlockData.register(BlockDoor.class, (Function<IBlockData, CraftBlockData>)((Function)CraftDoor::new));
        CraftBlockData.register(BlockDropper.class, (Function<IBlockData, CraftBlockData>)((Function)CraftDropper::new));
        CraftBlockData.register(BlockEndRod.class, (Function<IBlockData, CraftBlockData>)((Function)CraftEndRod::new));
        CraftBlockData.register(BlockEnderChest.class, (Function<IBlockData, CraftBlockData>)((Function)CraftEnderChest::new));
        CraftBlockData.register(BlockEnderPortalFrame.class, (Function<IBlockData, CraftBlockData>)((Function)CraftEnderPortalFrame::new));
        CraftBlockData.register(BlockFence.class, (Function<IBlockData, CraftBlockData>)((Function)CraftFence::new));
        CraftBlockData.register(BlockFenceGate.class, (Function<IBlockData, CraftBlockData>)((Function)CraftFenceGate::new));
        CraftBlockData.register(BlockFire.class, (Function<IBlockData, CraftBlockData>)((Function)CraftFire::new));
        CraftBlockData.register(BlockFloorSign.class, (Function<IBlockData, CraftBlockData>)((Function)CraftFloorSign::new));
        CraftBlockData.register(BlockFluids.class, (Function<IBlockData, CraftBlockData>)((Function)CraftFluids::new));
        CraftBlockData.register(BlockFurnaceFurace.class, (Function<IBlockData, CraftBlockData>)((Function)CraftFurnaceFurace::new));
        CraftBlockData.register(BlockGlazedTerracotta.class, (Function<IBlockData, CraftBlockData>)((Function)CraftGlazedTerracotta::new));
        CraftBlockData.register(BlockGrass.class, (Function<IBlockData, CraftBlockData>)((Function)CraftGrass::new));
        CraftBlockData.register(BlockGrindstone.class, (Function<IBlockData, CraftBlockData>)((Function)CraftGrindstone::new));
        CraftBlockData.register(BlockHay.class, (Function<IBlockData, CraftBlockData>)((Function)CraftHay::new));
        CraftBlockData.register(BlockHopper.class, (Function<IBlockData, CraftBlockData>)((Function)CraftHopper::new));
        CraftBlockData.register(BlockHugeMushroom.class, (Function<IBlockData, CraftBlockData>)((Function)CraftHugeMushroom::new));
        CraftBlockData.register(BlockIceFrost.class, (Function<IBlockData, CraftBlockData>)((Function)CraftIceFrost::new));
        CraftBlockData.register(BlockIronBars.class, (Function<IBlockData, CraftBlockData>)((Function)CraftIronBars::new));
        CraftBlockData.register(BlockJigsaw.class, (Function<IBlockData, CraftBlockData>)((Function)CraftJigsaw::new));
        CraftBlockData.register(BlockJukeBox.class, (Function<IBlockData, CraftBlockData>)((Function)CraftJukeBox::new));
        CraftBlockData.register(BlockKelp.class, (Function<IBlockData, CraftBlockData>)((Function)CraftKelp::new));
        CraftBlockData.register(BlockLadder.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLadder::new));
        CraftBlockData.register(BlockLantern.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLantern::new));
        CraftBlockData.register(BlockLectern.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLectern::new));
        CraftBlockData.register(BlockLever.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLever::new));
        CraftBlockData.register(BlockLoom.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLoom::new));
        CraftBlockData.register(BlockMinecartDetector.class, (Function<IBlockData, CraftBlockData>)((Function)CraftMinecartDetector::new));
        CraftBlockData.register(BlockMinecartTrack.class, (Function<IBlockData, CraftBlockData>)((Function)CraftMinecartTrack::new));
        CraftBlockData.register(BlockMycel.class, (Function<IBlockData, CraftBlockData>)((Function)CraftMycel::new));
        CraftBlockData.register(BlockNetherWart.class, (Function<IBlockData, CraftBlockData>)((Function)CraftNetherWart::new));
        CraftBlockData.register(BlockNote.class, (Function<IBlockData, CraftBlockData>)((Function)CraftNote::new));
        CraftBlockData.register(BlockObserver.class, (Function<IBlockData, CraftBlockData>)((Function)CraftObserver::new));
        CraftBlockData.register(BlockPortal.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPortal::new));
        CraftBlockData.register(BlockPotatoes.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPotatoes::new));
        CraftBlockData.register(BlockPoweredRail.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPoweredRail::new));
        CraftBlockData.register(BlockPressurePlateBinary.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPressurePlateBinary::new));
        CraftBlockData.register(BlockPressurePlateWeighted.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPressurePlateWeighted::new));
        CraftBlockData.register(BlockPumpkinCarved.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPumpkinCarved::new));
        CraftBlockData.register(BlockRedstoneComparator.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRedstoneComparator::new));
        CraftBlockData.register(BlockRedstoneLamp.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRedstoneLamp::new));
        CraftBlockData.register(BlockRedstoneOre.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRedstoneOre::new));
        CraftBlockData.register(BlockRedstoneTorch.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRedstoneTorch::new));
        CraftBlockData.register(BlockRedstoneTorchWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRedstoneTorchWall::new));
        CraftBlockData.register(BlockRedstoneWire.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRedstoneWire::new));
        CraftBlockData.register(BlockReed.class, (Function<IBlockData, CraftBlockData>)((Function)CraftReed::new));
        CraftBlockData.register(BlockRepeater.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRepeater::new));
        CraftBlockData.register(BlockRespawnAnchor.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRespawnAnchor::new));
        CraftBlockData.register(BlockRotatable.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRotatable::new));
        CraftBlockData.register(BlockSapling.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSapling::new));
        CraftBlockData.register(BlockScaffolding.class, (Function<IBlockData, CraftBlockData>)((Function)CraftScaffolding::new));
        CraftBlockData.register(BlockSeaPickle.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSeaPickle::new));
        CraftBlockData.register(BlockShulkerBox.class, (Function<IBlockData, CraftBlockData>)((Function)CraftShulkerBox::new));
        CraftBlockData.register(BlockSkull.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSkull::new));
        CraftBlockData.register(BlockSkullPlayer.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSkullPlayer::new));
        CraftBlockData.register(BlockSkullPlayerWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSkullPlayerWall::new));
        CraftBlockData.register(BlockSkullWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSkullWall::new));
        CraftBlockData.register(BlockSmoker.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSmoker::new));
        CraftBlockData.register(BlockSnow.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSnow::new));
        CraftBlockData.register(BlockSoil.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSoil::new));
        CraftBlockData.register(BlockStainedGlassPane.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStainedGlassPane::new));
        CraftBlockData.register(BlockStairs.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStairs::new));
        CraftBlockData.register(BlockStem.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStem::new));
        CraftBlockData.register(BlockStemAttached.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStemAttached::new));
        CraftBlockData.register(BlockStepAbstract.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStepAbstract::new));
        CraftBlockData.register(BlockStonecutter.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStonecutter::new));
        CraftBlockData.register(BlockStructure.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStructure::new));
        CraftBlockData.register(BlockSweetBerryBush.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSweetBerryBush::new));
        CraftBlockData.register(BlockTNT.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTNT::new));
        CraftBlockData.register(BlockTallPlant.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTallPlant::new));
        CraftBlockData.register(BlockTallPlantFlower.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTallPlantFlower::new));
        CraftBlockData.register(BlockTarget.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTarget::new));
        CraftBlockData.register(BlockTorchWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTorchWall::new));
        CraftBlockData.register(BlockTrapdoor.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTrapdoor::new));
        CraftBlockData.register(BlockTripwire.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTripwire::new));
        CraftBlockData.register(BlockTripwireHook.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTripwireHook::new));
        CraftBlockData.register(BlockTurtleEgg.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTurtleEgg::new));
        CraftBlockData.register(BlockTwistingVines.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTwistingVines::new));
        CraftBlockData.register(BlockVine.class, (Function<IBlockData, CraftBlockData>)((Function)CraftVine::new));
        CraftBlockData.register(BlockWallSign.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWallSign::new));
        CraftBlockData.register(BlockWeepingVines.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeepingVines::new));
        CraftBlockData.register(BlockWitherSkull.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWitherSkull::new));
        CraftBlockData.register(BlockWitherSkullWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWitherSkullWall::new));
        CraftBlockData.register(BrushableBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBrushable::new));
        CraftBlockData.register(CalibratedSculkSensorBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCalibratedSculkSensor::new));
        CraftBlockData.register(CandleBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCandle::new));
        CraftBlockData.register(CandleCakeBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCandleCake::new));
        CraftBlockData.register(CaveVinesBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCaveVines::new));
        CraftBlockData.register(CaveVinesPlantBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCaveVinesPlant::new));
        CraftBlockData.register(CeilingHangingSignBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCeilingHangingSign::new));
        CraftBlockData.register(ChiseledBookShelfBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftChiseledBookShelf::new));
        CraftBlockData.register(CopperBulbBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCopperBulb::new));
        CraftBlockData.register(CopperChestBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCopperChest::new));
        CraftBlockData.register(CopperGolemStatueBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCopperGolemStatue::new));
        CraftBlockData.register(CrafterBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCrafter::new));
        CraftBlockData.register(CreakingHeartBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCreakingHeart::new));
        CraftBlockData.register(DecoratedPotBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftDecoratedPot::new));
        CraftBlockData.register(DriedGhastBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftDriedGhast::new));
        CraftBlockData.register(FlowerBedBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftFlowerBed::new));
        CraftBlockData.register(GlowLichenBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftGlowLichen::new));
        CraftBlockData.register(HangingMossBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftHangingMoss::new));
        CraftBlockData.register(HangingRootsBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftHangingRoots::new));
        CraftBlockData.register(HeavyCoreBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftHeavyCore::new));
        CraftBlockData.register(InfestedRotatedPillarBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftInfestedRotatedPillar::new));
        CraftBlockData.register(LayeredCauldronBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLayeredCauldron::new));
        CraftBlockData.register(LeafLitterBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLeafLitter::new));
        CraftBlockData.register(LightBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLight::new));
        CraftBlockData.register(LightningRodBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLightningRod::new));
        CraftBlockData.register(MangroveLeavesBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftMangroveLeaves::new));
        CraftBlockData.register(MangrovePropaguleBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftMangrovePropagule::new));
        CraftBlockData.register(MangroveRootsBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftMangroveRoots::new));
        CraftBlockData.register(MossyCarpetBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftMossyCarpet::new));
        CraftBlockData.register(MultifaceBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftMultiface::new));
        CraftBlockData.register(PiglinWallSkullBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPiglinWallSkull::new));
        CraftBlockData.register(PitcherCropBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPitcherCrop::new));
        CraftBlockData.register(PointedDripstoneBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPointedDripstone::new));
        CraftBlockData.register(SculkCatalystBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSculkCatalyst::new));
        CraftBlockData.register(SculkSensorBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSculkSensor::new));
        CraftBlockData.register(SculkShriekerBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSculkShrieker::new));
        CraftBlockData.register(SculkVeinBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSculkVein::new));
        CraftBlockData.register(ShelfBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftShelf::new));
        CraftBlockData.register(SmallDripleafBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSmallDripleaf::new));
        CraftBlockData.register(SnifferEggBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSnifferEgg::new));
        CraftBlockData.register(TallSeagrassBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTallSeagrass::new));
        CraftBlockData.register(TestBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTest::new));
        CraftBlockData.register(TintedParticleLeavesBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTintedParticleLeaves::new));
        CraftBlockData.register(TorchflowerCropBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTorchflowerCrop::new));
        CraftBlockData.register(TrialSpawnerBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTrialSpawner::new));
        CraftBlockData.register(UntintedParticleLeavesBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftUntintedParticleLeaves::new));
        CraftBlockData.register(VaultBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftVault::new));
        CraftBlockData.register(WallHangingSignBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWallHangingSign::new));
        CraftBlockData.register(WaterloggedTransparentBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWaterloggedTransparent::new));
        CraftBlockData.register(WeatheringCopperBarsBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringCopperBars::new));
        CraftBlockData.register(WeatheringCopperBulbBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringCopperBulb::new));
        CraftBlockData.register(WeatheringCopperChainBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringCopperChain::new));
        CraftBlockData.register(WeatheringCopperChestBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringCopperChest::new));
        CraftBlockData.register(WeatheringCopperDoorBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringCopperDoor::new));
        CraftBlockData.register(WeatheringCopperGolemStatueBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringCopperGolemStatue::new));
        CraftBlockData.register(WeatheringCopperGrateBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringCopperGrate::new));
        CraftBlockData.register(WeatheringCopperSlabBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringCopperSlab::new));
        CraftBlockData.register(WeatheringCopperStairBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringCopperStair::new));
        CraftBlockData.register(WeatheringCopperTrapDoorBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringCopperTrapDoor::new));
        CraftBlockData.register(WeatheringLanternBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringLantern::new));
        CraftBlockData.register(WeatheringLightningRodBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringLightningRod::new));
        CraftBlockData.register(BlockPiston.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPiston::new));
        CraftBlockData.register(BlockPistonExtension.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPistonExtension::new));
        CraftBlockData.register(BlockPistonMoving.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPistonMoving::new));
    }
}

