/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.Items;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftProjectile;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class CraftAbstractArrow
extends CraftProjectile
implements AbstractArrow {
    public CraftAbstractArrow(CraftServer server, EntityArrow entity) {
        super(server, entity);
    }

    public void setKnockbackStrength(int knockbackStrength) {
    }

    public int getKnockbackStrength() {
        return 0;
    }

    public double getDamage() {
        return this.getHandle().u;
    }

    public void setDamage(double damage) {
        Preconditions.checkArgument((damage >= 0.0 ? 1 : 0) != 0, (String)"Damage value (%s) must be positive", (Object)damage);
        this.getHandle().i(damage);
    }

    public int getPierceLevel() {
        return this.getHandle().x();
    }

    public void setPierceLevel(int pierceLevel) {
        Preconditions.checkArgument((0 <= pierceLevel && pierceLevel <= 127 ? 1 : 0) != 0, (String)"Pierce level (%s) out of range, expected 0 < level < 127", (int)pierceLevel);
        this.getHandle().a((byte)pierceLevel);
    }

    public boolean isCritical() {
        return this.getHandle().w();
    }

    public void setCritical(boolean critical) {
        this.getHandle().r(critical);
    }

    @Override
    public ProjectileSource getShooter() {
        return this.getHandle().projectileSource;
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        if (shooter instanceof Entity) {
            this.getHandle().d(((CraftEntity)shooter).getHandle());
        } else {
            this.getHandle().d((net.minecraft.world.entity.Entity)null);
        }
        this.getHandle().projectileSource = shooter;
    }

    public boolean isInBlock() {
        return this.getHandle().f();
    }

    public Block getAttachedBlock() {
        if (!this.isInBlock()) {
            return null;
        }
        BlockPosition pos = this.getHandle().dK();
        return this.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
    }

    public AbstractArrow.PickupStatus getPickupStatus() {
        return AbstractArrow.PickupStatus.values()[this.getHandle().c.ordinal()];
    }

    public void setPickupStatus(AbstractArrow.PickupStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0, (Object)"PickupStatus cannot be null");
        this.getHandle().c = EntityArrow.PickupStatus.a(status.ordinal());
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().t = value;
    }

    public boolean isShotFromCrossbow() {
        net.minecraft.world.item.ItemStack firedFromWeapon = this.getHandle().eq();
        return firedFromWeapon != null && firedFromWeapon.a(Items.yz);
    }

    public void setShotFromCrossbow(boolean shotFromCrossbow) {
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().aQ);
    }

    public void setItem(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().aQ = CraftItemStack.asNMSCopy(item);
    }

    public ItemStack getWeapon() {
        return CraftItemStack.asBukkitCopy(this.getHandle().eq());
    }

    public void setWeapon(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().aR = CraftItemStack.asNMSCopy(item);
    }

    @Override
    public EntityArrow getHandle() {
        return (EntityArrow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftArrow";
    }
}

