/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.alchemy.PotionContents;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.craftbukkit.v1_21_R7.CraftParticle;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionUtil;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;

public class CraftAreaEffectCloud
extends CraftEntity
implements AreaEffectCloud {
    public CraftAreaEffectCloud(CraftServer server, EntityAreaEffectCloud entity) {
        super(server, entity);
    }

    @Override
    public EntityAreaEffectCloud getHandle() {
        return (EntityAreaEffectCloud)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftAreaEffectCloud";
    }

    public int getDuration() {
        return this.getHandle().h();
    }

    public void setDuration(int duration) {
        this.getHandle().a(duration);
    }

    public int getWaitTime() {
        return this.getHandle().aQ;
    }

    public void setWaitTime(int waitTime) {
        this.getHandle().d(waitTime);
    }

    public int getReapplicationDelay() {
        return this.getHandle().aR;
    }

    public void setReapplicationDelay(int delay) {
        this.getHandle().aR = delay;
    }

    public int getDurationOnUse() {
        return this.getHandle().aS;
    }

    public void setDurationOnUse(int duration) {
        this.getHandle().aS = duration;
    }

    public float getRadius() {
        return this.getHandle().c();
    }

    public void setRadius(float radius) {
        this.getHandle().a(radius);
    }

    public float getRadiusOnUse() {
        return this.getHandle().aT;
    }

    public void setRadiusOnUse(float radius) {
        this.getHandle().c(radius);
    }

    public float getRadiusPerTick() {
        return this.getHandle().aU;
    }

    public void setRadiusPerTick(float radius) {
        this.getHandle().d(radius);
    }

    public Particle getParticle() {
        return CraftParticle.minecraftToBukkit(this.getHandle().e().a());
    }

    public void setParticle(Particle particle) {
        this.setParticle(particle, null);
    }

    public <T> void setParticle(Particle particle, T data) {
        this.getHandle().a(CraftParticle.createParticleParam(particle, data));
    }

    public Color getColor() {
        return Color.fromRGB((int)this.getHandle().u.b());
    }

    public void setColor(Color color) {
        PotionContents old = this.getHandle().u;
        this.getHandle().a(new PotionContents(old.e(), Optional.of(color.asRGB()), old.d(), old.g()));
    }

    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        if (this.hasCustomEffect(effect.getType())) {
            if (!override) {
                return false;
            }
            this.removeCustomEffect(effect.getType());
        }
        this.getHandle().a(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().q();
        return true;
    }

    public void clearCustomEffects() {
        PotionContents old = this.getHandle().u;
        this.getHandle().a(new PotionContents(old.e(), old.f(), List.of(), old.g()));
        this.getHandle().q();
    }

    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MobEffect effect : this.getHandle().u.d()) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    public boolean hasCustomEffect(PotionEffectType type) {
        for (MobEffect effect : this.getHandle().u.d()) {
            if (!CraftPotionUtil.equals(effect.c(), type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomEffects() {
        return !this.getHandle().u.d().isEmpty();
    }

    public boolean removeCustomEffect(PotionEffectType effect) {
        if (!this.hasCustomEffect(effect)) {
            return false;
        }
        Holder<MobEffectList> minecraft = CraftPotionEffectType.bukkitToMinecraftHolder(effect);
        PotionContents old = this.getHandle().u;
        this.getHandle().a(new PotionContents(old.e(), old.f(), old.d().stream().filter(mobEffect -> !mobEffect.c().equals(minecraft)).toList(), old.g()));
        return true;
    }

    public void setBasePotionData(PotionData data) {
        this.setBasePotionType(CraftPotionUtil.fromBukkit(data));
    }

    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(this.getBasePotionType());
    }

    public void setBasePotionType(PotionType potionType) {
        if (potionType != null) {
            this.getHandle().a(this.getHandle().u.b(CraftPotionType.bukkitToMinecraftHolder(potionType)));
        } else {
            PotionContents old = this.getHandle().u;
            this.getHandle().a(new PotionContents(Optional.empty(), old.f(), old.d(), old.g()));
        }
    }

    public PotionType getBasePotionType() {
        return this.getHandle().u.e().map(CraftPotionType::minecraftHolderToBukkit).orElse(null);
    }

    public ProjectileSource getSource() {
        EntityLiving source = this.getHandle().n();
        return source == null ? null : (LivingEntity)source.getBukkitEntity();
    }

    public void setSource(ProjectileSource shooter) {
        if (shooter instanceof CraftLivingEntity) {
            CraftLivingEntity craftLivingEntity = (CraftLivingEntity)shooter;
            this.getHandle().a(craftLivingEntity.getHandle());
        } else {
            this.getHandle().a((EntityLiving)null);
        }
    }
}

