/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.cow.CowVariant;
import net.minecraft.world.entity.animal.cow.EntityCow;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAbstractCow;
import org.bukkit.craftbukkit.v1_21_R7.registry.CraftRegistryItem;
import org.bukkit.entity.Cow;

public class CraftCow
extends CraftAbstractCow
implements Cow {
    public CraftCow(CraftServer server, EntityCow entity) {
        super(server, entity);
    }

    @Override
    public EntityCow getHandle() {
        return (EntityCow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftCow";
    }

    public Cow.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().gP());
    }

    public void setVariant(Cow.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().b(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public static class CraftVariant
    extends CraftRegistryItem<CowVariant>
    implements Cow.Variant {
        public static Cow.Variant minecraftToBukkit(CowVariant minecraft) {
            return (Cow.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.aZ, Registry.COW_VARIANT);
        }

        public static Cow.Variant minecraftHolderToBukkit(Holder<CowVariant> minecraft) {
            return CraftVariant.minecraftToBukkit(minecraft.a());
        }

        public static CowVariant bukkitToMinecraft(Cow.Variant bukkit) {
            return (CowVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<CowVariant> bukkitToMinecraftHolder(Cow.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.aZ);
        }

        public CraftVariant(NamespacedKey key, Holder<CowVariant> handle) {
            super(key, handle);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }
}

