/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.util.Brightness;
import net.minecraft.world.entity.Display;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.entity.Display;
import org.bukkit.util.Transformation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CraftDisplay
extends CraftEntity
implements Display {
    public CraftDisplay(CraftServer server, net.minecraft.world.entity.Display entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.Display getHandle() {
        return (net.minecraft.world.entity.Display)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftDisplay";
    }

    public Transformation getTransformation() {
        com.mojang.math.Transformation nms = net.minecraft.world.entity.Display.a(this.getHandle().aD());
        return new Transformation(new Vector3f(nms.e()), new Quaternionf(nms.f()), new Vector3f(nms.g()), new Quaternionf(nms.h()));
    }

    public void setTransformation(Transformation transformation) {
        Preconditions.checkArgument((transformation != null ? 1 : 0) != 0, (Object)"Transformation cannot be null");
        this.getHandle().a(new com.mojang.math.Transformation((Vector3fc)transformation.getTranslation(), (Quaternionfc)transformation.getLeftRotation(), (Vector3fc)transformation.getScale(), (Quaternionfc)transformation.getRightRotation()));
    }

    public void setTransformationMatrix(Matrix4f transformationMatrix) {
        Preconditions.checkArgument((transformationMatrix != null ? 1 : 0) != 0, (Object)"Transformation matrix cannot be null");
        this.getHandle().a(new com.mojang.math.Transformation((Matrix4fc)transformationMatrix));
    }

    public int getInterpolationDuration() {
        return this.getHandle().k();
    }

    public void setInterpolationDuration(int duration) {
        this.getHandle().a(duration);
    }

    public int getTeleportDuration() {
        return this.getHandle().aD().a(net.minecraft.world.entity.Display.r);
    }

    public void setTeleportDuration(int duration) {
        Preconditions.checkArgument((duration >= 0 && duration <= 59 ? 1 : 0) != 0, (String)"duration (%s) cannot be lower than 0 or higher than 59", (int)duration);
        this.getHandle().aD().a(net.minecraft.world.entity.Display.r, duration);
    }

    public float getViewRange() {
        return this.getHandle().s();
    }

    public void setViewRange(float range) {
        this.getHandle().b(range);
    }

    public float getShadowRadius() {
        return this.getHandle().u();
    }

    public void setShadowRadius(float radius) {
        this.getHandle().c(radius);
    }

    public float getShadowStrength() {
        return this.getHandle().v();
    }

    public void setShadowStrength(float strength) {
        this.getHandle().d(strength);
    }

    public float getDisplayWidth() {
        return this.getHandle().w();
    }

    public void setDisplayWidth(float width) {
        this.getHandle().x(width);
    }

    public float getDisplayHeight() {
        return this.getHandle().y();
    }

    public void setDisplayHeight(float height) {
        this.getHandle().y(height);
    }

    public int getInterpolationDelay() {
        return this.getHandle().m();
    }

    public void setInterpolationDelay(int ticks) {
        this.getHandle().b(ticks);
    }

    public Display.Billboard getBillboard() {
        return Display.Billboard.valueOf((String)this.getHandle().p().name());
    }

    public void setBillboard(Display.Billboard billboard) {
        Preconditions.checkArgument((billboard != null ? 1 : 0) != 0, (Object)"Billboard cannot be null");
        this.getHandle().a(Display.BillboardConstraints.valueOf(billboard.name()));
    }

    public Color getGlowColorOverride() {
        int color = this.getHandle().x();
        return color == -1 ? null : Color.fromRGB((int)color);
    }

    public void setGlowColorOverride(Color color) {
        if (color == null) {
            this.getHandle().l(-1);
        } else {
            this.getHandle().l(color.asRGB());
        }
    }

    public Display.Brightness getBrightness() {
        Brightness nms = this.getHandle().q();
        return nms != null ? new Display.Brightness(nms.b(), nms.c()) : null;
    }

    public void setBrightness(Display.Brightness brightness) {
        if (brightness != null) {
            this.getHandle().a(new Brightness(brightness.getBlockLight(), brightness.getSkyLight()));
        } else {
            this.getHandle().a((Brightness)null);
        }
    }
}

