/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.entity.EntityFactory;
import org.bukkit.entity.EntitySnapshot;

public class CraftEntityFactory
implements EntityFactory {
    private final IRegistryCustom registry;

    public CraftEntityFactory(IRegistryCustom registry) {
        this.registry = registry;
    }

    public EntitySnapshot createEntitySnapshot(String input) {
        NBTTagCompound tag;
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"Input string cannot be null");
        try {
            tag = MojangsonParser.a(input);
        }
        catch (CommandSyntaxException e2) {
            throw new IllegalArgumentException("Could not parse Entity: " + input, e2);
        }
        ValueInput value = TagValueInput.a(ProblemReporter.a, (HolderLookup.a)this.registry, tag);
        EntityTypes type = EntityTypes.a(value).orElse(null);
        if (type == null) {
            throw new IllegalArgumentException("Could not parse Entity: " + input);
        }
        return CraftEntitySnapshot.create(tag, CraftEntityType.minecraftToBukkit(type));
    }
}

