/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R7.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryLectern;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.util.CraftMenus;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.model.PlayerModelPart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;

public class CraftHumanEntity
extends CraftLivingEntity
implements HumanEntity {
    private CraftInventoryPlayer inventory;
    private final CraftInventory enderChest;
    protected final PermissibleBase perm = new PermissibleBase((ServerOperator)this);
    private boolean op;
    private GameMode mode;

    public CraftHumanEntity(CraftServer server, EntityHuman entity) {
        super(server, entity);
        this.mode = server.getDefaultGameMode();
        this.inventory = new CraftInventoryPlayer(entity.gK());
        this.enderChest = new CraftInventory(entity.gZ());
    }

    public PlayerInventory getInventory() {
        return this.inventory;
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.inventory;
    }

    public Inventory getEnderChest() {
        return this.enderChest;
    }

    public MainHand getMainHand() {
        return this.getHandle().at() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT;
    }

    public boolean isModelPartShown(PlayerModelPart part) {
        Preconditions.checkArgument((part != null ? 1 : 0) != 0, (Object)"part cannot be null");
        net.minecraft.world.entity.player.PlayerModelPart nms = net.minecraft.world.entity.player.PlayerModelPart.valueOf(part.name());
        return this.getHandle().a(nms);
    }

    public ItemStack getItemInHand() {
        return this.getInventory().getItemInHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInHand(item);
    }

    public ItemStack getItemOnCursor() {
        return CraftItemStack.asCraftMirror(this.getHandle().cn.g());
    }

    public void setItemOnCursor(ItemStack item) {
        net.minecraft.world.item.ItemStack stack = CraftItemStack.asNMSCopy(item);
        this.getHandle().cn.a(stack);
        if (this instanceof CraftPlayer) {
            this.getHandle().cn.broadcastCarriedItem();
        }
    }

    public int getSleepTicks() {
        return this.getHandle().cF;
    }

    public boolean sleep(Location location, boolean force) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"Cannot sleep across worlds");
        BlockPosition blockposition = CraftLocation.toBlockPosition(location);
        IBlockData iblockdata = this.getHandle().ao().a_(blockposition);
        if (!(iblockdata.b() instanceof BlockBed)) {
            return false;
        }
        if (this.getHandle().startSleepInBed(blockposition, force).left().isPresent()) {
            return false;
        }
        iblockdata = (IBlockData)iblockdata.b(BlockBed.c, true);
        this.getHandle().ao().a(blockposition, iblockdata, 4);
        return true;
    }

    public void wakeup(boolean setSpawnLocation) {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        this.getHandle().a(true, setSpawnLocation);
    }

    public void startRiptideAttack(int duration, float damage, ItemStack attackItem) {
        Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0, (Object)"Duration must be greater than 0");
        Preconditions.checkArgument((damage >= 0.0f ? 1 : 0) != 0, (Object)"Damage must not be negative");
        this.getHandle().a(duration, damage, CraftItemStack.asNMSCopy(attackItem));
    }

    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        BlockPosition bed = this.getHandle().gp().get();
        return CraftLocation.toBukkit(bed, this.getWorld());
    }

    @Override
    public String getName() {
        return this.getHandle().da();
    }

    @Override
    public boolean isOp() {
        return this.op;
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @Override
    public void setOp(boolean value) {
        this.op = value;
        this.perm.recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    public GameMode getGameMode() {
        return this.mode;
    }

    public void setGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        this.mode = mode;
    }

    @Override
    public EntityHuman getHandle() {
        return (EntityHuman)this.entity;
    }

    public void setHandle(EntityHuman entity) {
        super.setHandle(entity);
        this.inventory = new CraftInventoryPlayer(entity.gK());
    }

    @Override
    public String toString() {
        return "CraftHumanEntity{id=" + this.getEntityId() + "name=" + this.getName() + "}";
    }

    public InventoryView getOpenInventory() {
        return this.getHandle().cn.getBukkitView();
    }

    public InventoryView openInventory(Inventory inventory) {
        InventoryHolder inventoryHolder;
        TileEntity te;
        CraftInventory craft;
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return null;
        }
        EntityPlayer player = (EntityPlayer)this.getHandle();
        Container formerContainer = this.getHandle().cn;
        ITileInventory tileInventory = null;
        if (inventory instanceof CraftInventoryDoubleChest) {
            tileInventory = ((CraftInventoryDoubleChest)inventory).tile;
        } else if (inventory instanceof CraftInventoryLectern) {
            tileInventory = ((CraftInventoryLectern)inventory).tile;
        } else if (inventory instanceof CraftInventory && (craft = (CraftInventory)inventory).getInventory() instanceof ITileInventory) {
            tileInventory = (ITileInventory)((Object)craft.getInventory());
        }
        if (tileInventory instanceof ITileInventory && tileInventory instanceof TileEntity && !(te = (TileEntity)((Object)tileInventory)).n()) {
            te.a(this.getHandle().ao());
        }
        if (tileInventory instanceof ITileInventory) {
            this.getHandle().a(tileInventory);
        } else if (inventory instanceof CraftInventoryAbstractHorse && (inventoryHolder = (craft = (CraftInventoryAbstractHorse)inventory).getInventory().getOwner()) instanceof CraftAbstractHorse) {
            CraftAbstractHorse horse = (CraftAbstractHorse)inventoryHolder;
            this.getHandle().a(horse.getHandle(), craft.getInventory());
        } else {
            Containers container = CraftContainer.getNotchInventoryType(inventory);
            CraftHumanEntity.openCustomInventory(inventory, player, container);
        }
        if (this.getHandle().cn == formerContainer) {
            return null;
        }
        this.getHandle().cn.checkReachable = false;
        return this.getHandle().cn.getBukkitView();
    }

    private static void openCustomInventory(Inventory inventory, EntityPlayer player, Containers<?> windowType) {
        if (player.g == null) {
            return;
        }
        Preconditions.checkArgument((windowType != null ? 1 : 0) != 0, (Object)"Unknown windowType");
        Container container = new CraftContainer(inventory, (EntityHuman)player, player.nextContainerCounter());
        container = CraftEventFactory.callInventoryOpenEvent(player, container);
        if (container == null) {
            return;
        }
        String title = container.getBukkitView().getTitle();
        player.g.b(new PacketPlayOutOpenWindow(container.l, windowType, CraftChatMessage.fromString(title)[0]));
        player.cn = container;
        player.a(container);
    }

    public InventoryView openWorkbench(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.CRAFTING_TABLE) {
            return null;
        }
        this.getHandle().a(Blocks.cX.m().a(this.getHandle().ao(), CraftLocation.toBlockPosition(location)));
        if (force) {
            this.getHandle().cn.checkReachable = false;
        }
        return this.getHandle().cn.getBukkitView();
    }

    public InventoryView openEnchanting(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.ENCHANTING_TABLE) {
            return null;
        }
        BlockPosition pos = CraftLocation.toBlockPosition(location);
        this.getHandle().a(Blocks.gg.m().a(this.getHandle().ao(), pos));
        if (force) {
            this.getHandle().cn.checkReachable = false;
        }
        return this.getHandle().cn.getBukkitView();
    }

    public void openInventory(InventoryView inventory) {
        Preconditions.checkArgument((boolean)this.equals(inventory.getPlayer()), (Object)"InventoryView must belong to the opening player");
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return;
        }
        if (((EntityPlayer)this.getHandle()).g == null) {
            return;
        }
        if (this.getHandle().cn != this.getHandle().cm) {
            ((EntityPlayer)this.getHandle()).g.a(new PacketPlayInCloseWindow(this.getHandle().cn.l));
        }
        EntityPlayer player = (EntityPlayer)this.getHandle();
        Container container = inventory instanceof CraftInventoryView ? ((CraftInventoryView)inventory).getHandle() : new CraftContainer(inventory, this.getHandle(), player.nextContainerCounter());
        if ((container = CraftEventFactory.callInventoryOpenEvent(player, container)) == null) {
            return;
        }
        Containers windowType = CraftContainer.getNotchInventoryType(inventory.getTopInventory());
        if (windowType == Containers.t) {
            CraftMenus.openMerchantMenu(player, (ContainerMerchant)container);
            return;
        }
        String title = inventory.getTitle();
        player.g.b(new PacketPlayOutOpenWindow(container.l, windowType, CraftChatMessage.fromString(title)[0]));
        player.cn = container;
        player.a(container);
    }

    public InventoryView openMerchant(Villager villager, boolean force) {
        Preconditions.checkNotNull((Object)villager, (Object)"villager cannot be null");
        return this.openMerchant((Merchant)villager, force);
    }

    public InventoryView openMerchant(Merchant merchant, boolean force) {
        IChatBaseComponent name;
        IMerchant mcMerchant;
        Preconditions.checkNotNull((Object)merchant, (Object)"merchant cannot be null");
        if (!force && merchant.isTrading()) {
            return null;
        }
        if (merchant.isTrading()) {
            merchant.getTrader().closeInventory();
        }
        int level = 1;
        if (merchant instanceof CraftAbstractVillager) {
            mcMerchant = ((CraftAbstractVillager)merchant).getHandle();
            name = ((CraftAbstractVillager)merchant).getHandle().R_();
            if (merchant instanceof CraftVillager) {
                level = ((CraftVillager)merchant).getHandle().gZ().c();
            }
        } else if (merchant instanceof CraftMerchantCustom) {
            mcMerchant = ((CraftMerchantCustom)merchant).getMerchant();
            name = ((CraftMerchantCustom)merchant).getMerchant().getScoreboardDisplayName();
        } else {
            throw new IllegalArgumentException("Can't open merchant " + merchant.toString());
        }
        mcMerchant.a(this.getHandle());
        mcMerchant.a(this.getHandle(), name, level);
        return this.getHandle().cn.getBukkitView();
    }

    public void closeInventory() {
        this.getHandle().r();
    }

    public boolean isBlocking() {
        return this.getHandle().gg();
    }

    public boolean isHandRaised() {
        return this.getHandle().fZ();
    }

    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        return false;
    }

    public int getEnchantmentSeed() {
        return this.getHandle().cv;
    }

    public void setEnchantmentSeed(int i2) {
        this.getHandle().cv = i2;
    }

    public int getExpToLevel() {
        return this.getHandle().gU();
    }

    public float getAttackCooldown() {
        return this.getHandle().I(0.5f);
    }

    public boolean hasCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        return this.hasCooldown(new ItemStack(material));
    }

    public int getCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        return this.getCooldown(new ItemStack(material));
    }

    public void setCooldown(Material material, int ticks) {
        this.setCooldown(new ItemStack(material), ticks);
    }

    public boolean hasCooldown(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        return this.getHandle().hh().a(CraftItemStack.asNMSCopy(item));
    }

    public int getCooldown(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        MinecraftKey group = this.getHandle().hh().b(CraftItemStack.asNMSCopy(item));
        if (group == null) {
            return 0;
        }
        ItemCooldown.Info cooldown = this.getHandle().hh().a.get(group);
        return cooldown == null ? 0 : Math.max(0, cooldown.b() - this.getHandle().hh().b);
    }

    public void setCooldown(ItemStack item, int ticks) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative cooldown");
        this.getHandle().hh().a(CraftItemStack.asNMSCopy(item), ticks);
    }

    public boolean discoverRecipe(NamespacedKey recipe) {
        return this.discoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int discoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().a(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean undiscoverRecipe(NamespacedKey recipe) {
        return this.undiscoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int undiscoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().b(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        return false;
    }

    public Set<NamespacedKey> getDiscoveredRecipes() {
        return ImmutableSet.of();
    }

    private Collection<RecipeHolder<?>> bukkitKeysToMinecraftRecipes(Collection<NamespacedKey> recipeKeys) {
        ArrayList recipes = new ArrayList();
        CraftingManager manager = this.getHandle().ao().s().aJ();
        for (NamespacedKey recipeKey : recipeKeys) {
            Optional<RecipeHolder<?>> recipe = manager.b(CraftRecipe.toMinecraft(recipeKey));
            if (!recipe.isPresent()) continue;
            recipes.add(recipe.get());
        }
        return recipes;
    }

    public Entity getShoulderEntityLeft() {
        EntityHuman entityHuman = this.getHandle();
        if (!(entityHuman instanceof EntityPlayer)) {
            return null;
        }
        EntityPlayer handle = (EntityPlayer)entityHuman;
        if (!handle.al().j()) {
            net.minecraft.world.entity.Entity shoulder = handle.getEntityOnShoulder(handle.al());
            return shoulder == null ? null : shoulder.getBukkitEntity();
        }
        return null;
    }

    public void setShoulderEntityLeft(Entity entity) {
        EntityHuman entityHuman = this.getHandle();
        if (!(entityHuman instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer handle = (EntityPlayer)entityHuman;
        handle.b(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public Entity getShoulderEntityRight() {
        EntityHuman entityHuman = this.getHandle();
        if (!(entityHuman instanceof EntityPlayer)) {
            return null;
        }
        EntityPlayer handle = (EntityPlayer)entityHuman;
        if (!handle.am().j()) {
            net.minecraft.world.entity.Entity shoulder = handle.getEntityOnShoulder(handle.am());
            return shoulder == null ? null : shoulder.getBukkitEntity();
        }
        return null;
    }

    public void setShoulderEntityRight(Entity entity) {
        EntityHuman entityHuman = this.getHandle();
        if (!(entityHuman instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer handle = (EntityPlayer)entityHuman;
        handle.c(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public boolean dropItem(boolean dropAll) {
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return false;
        }
        return ((EntityPlayer)this.getHandle()).dropItem(dropAll) != null;
    }

    public float getExhaustion() {
        return this.getHandle().gW().e;
    }

    public void setExhaustion(float value) {
        this.getHandle().gW().e = value;
    }

    public float getSaturation() {
        return this.getHandle().gW().d;
    }

    public void setSaturation(float value) {
        this.getHandle().gW().d = value;
    }

    public int getFoodLevel() {
        return this.getHandle().gW().c;
    }

    public void setFoodLevel(int value) {
        this.getHandle().gW().c = value;
    }

    public int getSaturatedRegenRate() {
        return this.getHandle().gW().saturatedRegenRate;
    }

    public void setSaturatedRegenRate(int i2) {
        this.getHandle().gW().saturatedRegenRate = i2;
    }

    public int getUnsaturatedRegenRate() {
        return this.getHandle().gW().unsaturatedRegenRate;
    }

    public void setUnsaturatedRegenRate(int i2) {
        this.getHandle().gW().unsaturatedRegenRate = i2;
    }

    public int getStarvationRate() {
        return this.getHandle().gW().starvationRate;
    }

    public void setStarvationRate(int i2) {
        this.getHandle().gW().starvationRate = i2;
    }

    public Location getLastDeathLocation() {
        return this.getHandle().hk().map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public void setLastDeathLocation(Location location) {
        if (location == null) {
            this.getHandle().d(Optional.empty());
        } else {
            this.getHandle().d(Optional.of(CraftMemoryMapper.toNms(location)));
        }
    }

    public Firework fireworkBoost(ItemStack fireworkItemStack) {
        Preconditions.checkArgument((fireworkItemStack != null ? 1 : 0) != 0, (Object)"fireworkItemStack must not be null");
        Preconditions.checkArgument((fireworkItemStack.getType() == Material.FIREWORK_ROCKET ? 1 : 0) != 0, (String)"fireworkItemStack must be of type %s", (Object)Material.FIREWORK_ROCKET);
        EntityFireworks fireworks = new EntityFireworks(this.getHandle().ao(), CraftItemStack.asNMSCopy(fireworkItemStack), this.getHandle());
        boolean success = this.getHandle().ao().addFreshEntity(fireworks, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return success ? (Firework)fireworks.getBukkitEntity() : null;
    }

    @Override
    public Entity copy() {
        throw new UnsupportedOperationException("Cannot copy human entities");
    }

    @Override
    public Entity copy(Location location) {
        throw new UnsupportedOperationException("Cannot copy human entities");
    }
}

