/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.TransmuteResult;
import net.minecraft.world.level.IMaterial;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.recipe.CookingBookCategory;

public interface CraftRecipe
extends Recipe {
    public void addToCraftingManager();

    default public Optional<RecipeItemStack> toNMSOptional(RecipeChoice bukkit, boolean requireNotEmpty) {
        return bukkit == null ? Optional.empty() : Optional.of(this.toNMS(bukkit, requireNotEmpty));
    }

    default public RecipeItemStack toNMS(RecipeChoice bukkit, boolean requireNotEmpty) {
        RecipeItemStack stack;
        if (bukkit == null) {
            stack = RecipeItemStack.a(new IMaterial[0]);
        } else if (bukkit instanceof RecipeChoice.MaterialChoice) {
            stack = RecipeItemStack.a(((RecipeChoice.MaterialChoice)bukkit).getChoices().stream().map(mat -> CraftItemType.bukkitToMinecraft(mat)));
        } else if (bukkit instanceof RecipeChoice.ExactChoice) {
            stack = RecipeItemStack.ofStacks(((RecipeChoice.ExactChoice)bukkit).getChoices().stream().map(mat -> CraftItemStack.asNMSCopy(mat)).toList());
        } else {
            throw new IllegalArgumentException("Unknown recipe stack instance " + String.valueOf(bukkit));
        }
        if (requireNotEmpty) {
            Preconditions.checkArgument((!stack.b() ? 1 : 0) != 0, (Object)"Recipe requires at least one non-air choice");
        }
        return stack;
    }

    default public TransmuteResult toNMS(ItemStack stack) {
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(stack);
        return new TransmuteResult(nms.i(), nms.N(), nms.d());
    }

    public static RecipeChoice toBukkit(Optional<RecipeItemStack> list) {
        return list.map(CraftRecipe::toBukkit).orElse(null);
    }

    public static RecipeChoice toBukkit(RecipeItemStack list) {
        if (list.b()) {
            return null;
        }
        if (list.isExact()) {
            ArrayList<ItemStack> choices = new ArrayList<ItemStack>(list.itemStacks().size());
            for (net.minecraft.world.item.ItemStack i3 : list.itemStacks()) {
                choices.add(CraftItemStack.asBukkitCopy(i3));
            }
            return new RecipeChoice.ExactChoice(choices);
        }
        List<Material> choices = list.a().map(i2 -> CraftItemType.minecraftToBukkit((Item)i2.a())).toList();
        return new RecipeChoice.MaterialChoice(choices);
    }

    public static ItemStack toBukkit(TransmuteResult transmute) {
        net.minecraft.world.item.ItemStack nms = new net.minecraft.world.item.ItemStack(transmute.b(), transmute.c(), transmute.d());
        return CraftItemStack.asBukkitCopy(nms);
    }

    public static CraftingBookCategory getCategory(org.bukkit.inventory.recipe.CraftingBookCategory bukkit) {
        return CraftingBookCategory.valueOf(bukkit.name());
    }

    public static org.bukkit.inventory.recipe.CraftingBookCategory getCategory(CraftingBookCategory nms) {
        return org.bukkit.inventory.recipe.CraftingBookCategory.valueOf((String)nms.name());
    }

    public static net.minecraft.world.item.crafting.CookingBookCategory getCategory(CookingBookCategory bukkit) {
        return net.minecraft.world.item.crafting.CookingBookCategory.valueOf(bukkit.name());
    }

    public static CookingBookCategory getCategory(net.minecraft.world.item.crafting.CookingBookCategory nms) {
        return CookingBookCategory.valueOf((String)nms.name());
    }

    public static ResourceKey<IRecipe<?>> toMinecraft(NamespacedKey key) {
        return ResourceKey.a(Registries.bK, CraftNamespacedKey.toMinecraft(key));
    }
}

