/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.components;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.food.FoodInfo;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.inventory.meta.components.FoodComponent;

@SerializableAs(value="Food")
public final class CraftFoodComponent
implements FoodComponent {
    private FoodInfo handle;

    public CraftFoodComponent(FoodInfo food) {
        this.handle = food;
    }

    public CraftFoodComponent(CraftFoodComponent food) {
        this.handle = food.handle;
    }

    public CraftFoodComponent(Map<String, Object> map) {
        Integer nutrition = SerializableMeta.getObject(Integer.class, map, "nutrition", false);
        Float saturationModifier = SerializableMeta.getObject(Float.class, map, "saturation", false);
        Boolean canAlwaysEat = SerializableMeta.getBoolean(map, "can-always-eat");
        this.handle = new FoodInfo(nutrition, saturationModifier.floatValue(), canAlwaysEat);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("nutrition", this.getNutrition());
        result.put("saturation", Float.valueOf(this.getSaturation()));
        result.put("can-always-eat", this.canAlwaysEat());
        return result;
    }

    public FoodInfo getHandle() {
        return this.handle;
    }

    public int getNutrition() {
        return this.handle.a();
    }

    public void setNutrition(int nutrition) {
        Preconditions.checkArgument((nutrition >= 0 ? 1 : 0) != 0, (Object)"Nutrition cannot be negative");
        this.handle = new FoodInfo(nutrition, this.handle.b(), this.handle.c());
    }

    public float getSaturation() {
        return this.handle.b();
    }

    public void setSaturation(float saturation) {
        this.handle = new FoodInfo(this.handle.a(), saturation, this.handle.c());
    }

    public boolean canAlwaysEat() {
        return this.handle.c();
    }

    public void setCanAlwaysEat(boolean canAlwaysEat) {
        this.handle = new FoodInfo(this.handle.a(), this.handle.b(), canAlwaysEat);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftFoodComponent other = (CraftFoodComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public String toString() {
        return "CraftFoodComponent{handle=" + String.valueOf(this.handle) + "}";
    }
}

