/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.components;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.item.component.UseEffects;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.inventory.meta.components.UseEffectsComponent;

@SerializableAs(value="UseEffects")
public final class CraftUseEffectsComponent
implements UseEffectsComponent {
    private UseEffects handle;

    public CraftUseEffectsComponent(UseEffects handle) {
        this.handle = handle;
    }

    public CraftUseEffectsComponent(CraftUseEffectsComponent component) {
        this.handle = component.handle;
    }

    public CraftUseEffectsComponent(Map<String, Object> map) {
        boolean canSprint = SerializableMeta.getBoolean(map, "can-sprint");
        boolean interactVibrations = SerializableMeta.getBoolean(map, "interact-vibrations");
        Float speedMultiplier = SerializableMeta.getObject(Float.class, map, "speed-multiplier", false);
        this.handle = new UseEffects(canSprint, interactVibrations, speedMultiplier.floatValue());
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("can-sprint", this.canSprint());
        result.put("interact-vibrations", this.isInteractVibrations());
        result.put("speed-multiplier", Float.valueOf(this.getSpeedMultiplier()));
        return result;
    }

    public UseEffects getHandle() {
        return this.handle;
    }

    public boolean canSprint() {
        return this.handle.a();
    }

    public void setCanSprint(boolean sprint) {
        this.handle = new UseEffects(sprint, this.handle.b(), this.handle.c());
    }

    public boolean isInteractVibrations() {
        return this.handle.b();
    }

    public void setInteractVibrations(boolean interactVibrations) {
        this.handle = new UseEffects(this.handle.a(), interactVibrations, this.handle.c());
    }

    public float getSpeedMultiplier() {
        return this.handle.c();
    }

    public void setSpeedMultiplier(float multiplier) {
        Preconditions.checkArgument((0.0f <= multiplier && multiplier <= 1.0f ? 1 : 0) != 0, (Object)"multiplier must be in range [0,1]");
        this.handle = new UseEffects(this.handle.a(), this.handle.b(), multiplier);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftUseEffectsComponent other = (CraftUseEffectsComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public String toString() {
        return "CraftUseEffectsComponent{handle=" + String.valueOf(this.handle) + "}";
    }
}

