/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.components.consumable.effects;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.inventory.ItemMetaKey;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.consumable.effects.CraftConsumableEffect;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionUtil;
import org.bukkit.inventory.meta.components.consumable.effects.ConsumableApplyEffects;
import org.bukkit.potion.PotionEffect;

@SerializableAs(value="ConsumableApplyEffects")
public class CraftConsumableApplyEffects
extends CraftConsumableEffect<ApplyStatusEffectsConsumeEffect>
implements ConsumableApplyEffects {
    static final ItemMetaKey POTIONS = new ItemMetaKey("effects");

    public CraftConsumableApplyEffects(ApplyStatusEffectsConsumeEffect consumeEffect) {
        super(consumeEffect);
    }

    public CraftConsumableApplyEffects(CraftConsumableApplyEffects consumeEffect) {
        super(consumeEffect);
    }

    public CraftConsumableApplyEffects(Map<String, Object> map) {
        super(map);
        ArrayList<PotionEffect> effectList = new ArrayList<PotionEffect>();
        Iterable rawEffectTypeList = SerializableMeta.getObject(Iterable.class, map, POTIONS, true);
        if (rawEffectTypeList == null) {
            return;
        }
        for (Object obj : rawEffectTypeList) {
            Preconditions.checkArgument((boolean)(obj instanceof PotionEffect), (String)"Object (%s) in effect list is not valid", obj.getClass());
            effectList.add((PotionEffect)obj);
        }
        Float probability = SerializableMeta.getObject(Float.class, map, "probability", false);
        this.handle = new ApplyStatusEffectsConsumeEffect(effectList.stream().map(CraftPotionUtil::fromBukkit).toList(), probability.floatValue());
    }

    public List<PotionEffect> getEffects() {
        List<MobEffect> mobEffectList = ((ApplyStatusEffectsConsumeEffect)this.getHandle()).b();
        return mobEffectList.stream().map(CraftPotionUtil::toBukkit).toList();
    }

    public void setEffects(List<PotionEffect> list) {
        this.handle = new ApplyStatusEffectsConsumeEffect(list.stream().map(CraftPotionUtil::fromBukkit).toList());
    }

    public PotionEffect addEffect(PotionEffect potionEffect) {
        List<MobEffect> mobEffectList = ((ApplyStatusEffectsConsumeEffect)this.getHandle()).b();
        mobEffectList.add(CraftPotionUtil.fromBukkit(potionEffect));
        this.handle = new ApplyStatusEffectsConsumeEffect(mobEffectList, ((ApplyStatusEffectsConsumeEffect)this.handle).c());
        return potionEffect;
    }

    public float getProbability() {
        return ((ApplyStatusEffectsConsumeEffect)this.getHandle()).c();
    }

    public void setProbability(float probability) {
        Preconditions.checkArgument((probability >= 0.0f && probability <= 1.0f ? 1 : 0) != 0, (String)"Probability must be between 0.0f and 1.0f but is %s", (Object)Float.valueOf(probability));
        this.handle = new ApplyStatusEffectsConsumeEffect(((ApplyStatusEffectsConsumeEffect)this.getHandle()).b(), probability);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(CraftConsumableApplyEffects.POTIONS.BUKKIT, ImmutableList.copyOf(this.getEffects()));
        return result;
    }
}

