/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.view.builder;

import com.google.common.base.Preconditions;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.InventoryViewBuilder;

public abstract class CraftAbstractInventoryViewBuilder<V extends InventoryView>
implements InventoryViewBuilder<V> {
    protected final Containers<?> handle;
    protected boolean checkReachable = false;
    protected String title = null;

    public CraftAbstractInventoryViewBuilder(Containers<?> handle) {
        this.handle = handle;
    }

    public InventoryViewBuilder<V> title(String title) {
        this.title = title;
        return this;
    }

    public V build(HumanEntity player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"The given player must not be null");
        Preconditions.checkArgument((this.title != null ? 1 : 0) != 0, (Object)"The given title must not be null");
        Preconditions.checkArgument((boolean)(player instanceof CraftHumanEntity), (Object)"The given player must be a CraftHumanEntity");
        CraftHumanEntity craftHuman = (CraftHumanEntity)player;
        Preconditions.checkArgument((boolean)(craftHuman.getHandle() instanceof EntityPlayer), (Object)"The given player must be an EntityPlayer");
        EntityPlayer serverPlayer = (EntityPlayer)craftHuman.getHandle();
        Container container = this.buildContainer(serverPlayer);
        container.checkReachable = this.checkReachable;
        container.setTitle(CraftChatMessage.fromString(this.title)[0]);
        return (V)container.getBukkitView();
    }

    protected abstract Container buildContainer(EntityPlayer var1);
}

