/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.legacy.reroute;

import com.google.common.base.Preconditions;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.DoNotReroute;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.InjectCompatibility;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.InjectPluginName;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.InjectPluginVersion;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.NotInBukkit;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.RequireCompatibility;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.RequirePluginVersion;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.RequirePluginVersionData;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.Reroute;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.RerouteArgument;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.RerouteArgumentType;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.RerouteMethodData;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.RerouteMethodName;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.RerouteReturn;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.RerouteReturnType;
import org.bukkit.craftbukkit.v1_21_R7.legacy.reroute.RerouteStatic;
import org.bukkit.craftbukkit.v1_21_R7.util.ApiVersion;
import org.objectweb.asm.Type;

public class RerouteBuilder {
    private final List<Class<?>> classes = new ArrayList();
    private final Predicate<String> compatibilityPresent;

    private RerouteBuilder(Predicate<String> compatibilityPresent) {
        this.compatibilityPresent = compatibilityPresent;
    }

    public static RerouteBuilder create(Predicate<String> compatibilityPresent) {
        return new RerouteBuilder(compatibilityPresent);
    }

    public RerouteBuilder forClass(Class<?> clazz) {
        this.classes.add(clazz);
        return this;
    }

    public Reroute build() {
        HashMap<String, Reroute.RerouteDataHolder> rerouteDataHolderMap = new HashMap<String, Reroute.RerouteDataHolder>();
        for (Class<?> clazz : this.classes) {
            List<RerouteMethodData> data = RerouteBuilder.buildFromClass(clazz, this.compatibilityPresent);
            data.forEach(value -> rerouteDataHolderMap.computeIfAbsent(value.methodKey(), v2 -> new Reroute.RerouteDataHolder()).add((RerouteMethodData)value));
        }
        return new Reroute(rerouteDataHolderMap);
    }

    private static List<RerouteMethodData> buildFromClass(Class<?> clazz, Predicate<String> compatibilityPresent) {
        Preconditions.checkArgument((!clazz.isInterface() ? 1 : 0) != 0, (Object)"Interface Classes are currently not supported");
        ArrayList<RerouteMethodData> result = new ArrayList<RerouteMethodData>();
        boolean shouldInclude = RerouteBuilder.shouldInclude(RerouteBuilder.getRequireCompatibility(clazz), true, compatibilityPresent);
        for (Method method : clazz.getDeclaredMethods()) {
            if (!RerouteBuilder.isMethodValid(method) || !RerouteBuilder.shouldInclude(RerouteBuilder.getRequireCompatibility(method), shouldInclude, compatibilityPresent)) continue;
            result.add(RerouteBuilder.buildFromMethod(method));
        }
        return result;
    }

    private static RerouteMethodData buildFromMethod(Method method) {
        Type sourceOwner;
        RerouteReturn rerouteReturn = new RerouteReturn(Type.getReturnType((Method)method));
        ArrayList<RerouteArgument> arguments = new ArrayList<RerouteArgument>();
        ArrayList<RerouteArgument> sourceArguments = new ArrayList<RerouteArgument>();
        for (Parameter parameter : method.getParameters()) {
            Type type = Type.getType(parameter.getType());
            int count = 0;
            boolean injectPluginName = false;
            boolean injectPluginVersion = false;
            String injectCompatibility = null;
            if (parameter.isAnnotationPresent(InjectPluginName.class)) {
                if (parameter.getType() != String.class) {
                    throw new RuntimeException("Plugin name argument must be of type name, but got " + String.valueOf(parameter.getType()));
                }
                injectPluginName = true;
                ++count;
            }
            if (parameter.isAnnotationPresent(InjectPluginVersion.class)) {
                if (parameter.getType() != ApiVersion.class) {
                    throw new RuntimeException("Plugin version argument must be of type ApiVersion, but got " + String.valueOf(parameter.getType()));
                }
                injectPluginVersion = true;
                ++count;
            }
            if (parameter.isAnnotationPresent(InjectCompatibility.class)) {
                if (parameter.getType() != Boolean.TYPE) {
                    throw new RuntimeException("Compatibility argument must be of type boolean, but got " + String.valueOf(parameter.getType()));
                }
                injectCompatibility = parameter.getAnnotation(InjectCompatibility.class).value();
                ++count;
            }
            if (count > 1) {
                throw new RuntimeException("Wtf?");
            }
            RerouteArgumentType rerouteArgumentType = parameter.getAnnotation(RerouteArgumentType.class);
            if (count == 1 && rerouteArgumentType != null) {
                throw new RuntimeException("Wtf?");
            }
            Type sourceType = rerouteArgumentType != null ? Type.getObjectType((String)rerouteArgumentType.value()) : type;
            RerouteArgument argument = new RerouteArgument(type, sourceType, injectPluginName, injectPluginVersion, injectCompatibility);
            arguments.add(argument);
            if (count != 0) continue;
            sourceArguments.add(argument);
        }
        RerouteStatic rerouteStatic = method.getAnnotation(RerouteStatic.class);
        if (rerouteStatic != null) {
            sourceOwner = Type.getObjectType((String)rerouteStatic.value());
        } else {
            if (sourceArguments.isEmpty()) {
                throw new RuntimeException("Source argument list is empty, no owner class found");
            }
            RerouteArgument argument = (RerouteArgument)sourceArguments.getFirst();
            sourceOwner = argument.sourceType();
            sourceArguments.remove(argument);
        }
        RerouteReturnType rerouteReturnType = method.getAnnotation(RerouteReturnType.class);
        Type returnType = rerouteReturnType != null ? Type.getObjectType((String)rerouteReturnType.value()) : rerouteReturn.type();
        Type sourceDesc = Type.getMethodType((Type)returnType, (Type[])((Type[])sourceArguments.stream().map(RerouteArgument::sourceType).toArray(Type[]::new)));
        RerouteMethodName rerouteMethodName = method.getAnnotation(RerouteMethodName.class);
        String methodName = rerouteMethodName != null ? rerouteMethodName.value() : method.getName();
        String methodKey = sourceDesc.getDescriptor() + methodName;
        Type targetType = Type.getType((Method)method);
        boolean inBukkit = !method.isAnnotationPresent(NotInBukkit.class) && !method.getDeclaringClass().isAnnotationPresent(NotInBukkit.class);
        RequirePluginVersionData requiredPluginVersion = null;
        if (method.isAnnotationPresent(RequirePluginVersion.class)) {
            requiredPluginVersion = RequirePluginVersionData.create(method.getAnnotation(RequirePluginVersion.class));
        } else if (method.getDeclaringClass().isAnnotationPresent(RequirePluginVersion.class)) {
            requiredPluginVersion = RequirePluginVersionData.create(method.getDeclaringClass().getAnnotation(RequirePluginVersion.class));
        }
        return new RerouteMethodData(methodKey, sourceDesc, sourceOwner, methodName, rerouteStatic != null, targetType, Type.getInternalName(method.getDeclaringClass()), method.getName(), arguments, rerouteReturn, inBukkit, requiredPluginVersion);
    }

    private static boolean isMethodValid(Method method) {
        if (method.isBridge()) {
            return false;
        }
        if (method.isSynthetic()) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        return !method.isAnnotationPresent(DoNotReroute.class);
    }

    private static String getRequireCompatibility(AnnotatedElement element) {
        RequireCompatibility annotation = element.getAnnotation(RequireCompatibility.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    private static boolean shouldInclude(String string, boolean parent, Predicate<String> compatibilityPresent) {
        if (string == null) {
            return parent;
        }
        return compatibilityPresent.test(string);
    }
}

