/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.profile;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.ClientAsset;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.entity.player.PlayerSkin;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.configuration.ConfigSerializationUtil;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.profile.PlayerSkinPatch;
import org.bukkit.profile.PlayerTextures;

@SerializableAs(value="PlayerSkinPatch")
public final class CraftPlayerSkinPatch
implements PlayerSkinPatch {
    private NamespacedKey texturePatch;
    private NamespacedKey capeTexturePatch;
    private NamespacedKey elytraTexturePatch;
    private PlayerTextures.SkinModel modelPatch;

    public CraftPlayerSkinPatch(NamespacedKey texturePatch, NamespacedKey capeTexturePatch, NamespacedKey elytraTexturePatch, PlayerTextures.SkinModel modelPatch) {
        this.texturePatch = texturePatch;
        this.capeTexturePatch = capeTexturePatch;
        this.elytraTexturePatch = elytraTexturePatch;
        this.modelPatch = modelPatch;
    }

    public CraftPlayerSkinPatch() {
        this(null, null, null, null);
    }

    public CraftPlayerSkinPatch(PlayerSkinPatch patch) {
        this(patch.getTexturePatch(), patch.getCapeTexturePatch(), patch.getElytraTexturePatch(), patch.getModelPatch());
    }

    public CraftPlayerSkinPatch(PlayerSkin.Patch patch) {
        this(patch.a().map(ClientAsset.b::a).map(CraftNamespacedKey::fromMinecraft).orElse(null), patch.b().map(ClientAsset.b::a).map(CraftNamespacedKey::fromMinecraft).orElse(null), patch.c().map(ClientAsset.b::a).map(CraftNamespacedKey::fromMinecraft).orElse(null), patch.d().map(model -> model == PlayerModelType.b ? PlayerTextures.SkinModel.CLASSIC : PlayerTextures.SkinModel.valueOf((String)model.name())).orElse(null));
    }

    public NamespacedKey getTexturePatch() {
        return this.texturePatch;
    }

    public void setTexturePatch(NamespacedKey texturePatch) {
        this.texturePatch = texturePatch;
    }

    public NamespacedKey getCapeTexturePatch() {
        return this.capeTexturePatch;
    }

    public void setCapeTexturePatch(NamespacedKey capeTexturePatch) {
        this.capeTexturePatch = capeTexturePatch;
    }

    public NamespacedKey getElytraTexturePatch() {
        return this.elytraTexturePatch;
    }

    public void setElytraTexturePatch(NamespacedKey elytraTexturePatch) {
        this.elytraTexturePatch = elytraTexturePatch;
    }

    public PlayerTextures.SkinModel getModelPatch() {
        return this.modelPatch;
    }

    public void setModelPatch(PlayerTextures.SkinModel modelPatch) {
        this.modelPatch = modelPatch;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.texturePatch);
        hash = 47 * hash + Objects.hashCode(this.capeTexturePatch);
        hash = 47 * hash + Objects.hashCode(this.elytraTexturePatch);
        hash = 47 * hash + Objects.hashCode(this.modelPatch);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftPlayerSkinPatch other = (CraftPlayerSkinPatch)obj;
        if (!Objects.equals(this.texturePatch, other.texturePatch)) {
            return false;
        }
        if (!Objects.equals(this.capeTexturePatch, other.capeTexturePatch)) {
            return false;
        }
        if (!Objects.equals(this.elytraTexturePatch, other.elytraTexturePatch)) {
            return false;
        }
        return this.modelPatch == other.modelPatch;
    }

    public String toString() {
        return "CraftPlayerSkinPatch{texturePatch=" + String.valueOf(this.texturePatch) + ", capeTexturePatch=" + String.valueOf(this.capeTexturePatch) + ", elytraTexturePatch=" + String.valueOf(this.elytraTexturePatch) + ", modelPatch=" + String.valueOf(this.modelPatch) + "}";
    }

    public boolean isEmpty() {
        return this.texturePatch == null && this.capeTexturePatch == null && this.elytraTexturePatch == null && this.modelPatch == null;
    }

    public PlayerSkin.Patch toMinecraft() {
        return PlayerSkin.Patch.a(Optional.ofNullable(this.texturePatch).map(CraftNamespacedKey::toMinecraft).map(ClientAsset.b::new), Optional.ofNullable(this.capeTexturePatch).map(CraftNamespacedKey::toMinecraft).map(ClientAsset.b::new), Optional.ofNullable(this.elytraTexturePatch).map(CraftNamespacedKey::toMinecraft).map(ClientAsset.b::new), Optional.ofNullable(this.modelPatch).map(model -> model == PlayerTextures.SkinModel.CLASSIC ? PlayerModelType.b : PlayerModelType.valueOf(model.name())));
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.texturePatch != null) {
            map.put("texture", this.texturePatch);
        }
        if (this.capeTexturePatch != null) {
            map.put("cape", this.capeTexturePatch);
        }
        if (this.elytraTexturePatch != null) {
            map.put("elytra", this.elytraTexturePatch);
        }
        if (this.modelPatch != null) {
            map.put("model", this.modelPatch.name());
        }
        return map;
    }

    public static CraftPlayerSkinPatch deserialize(Map<String, Object> map) {
        String texture = ConfigSerializationUtil.getString(map, "texture", true);
        String cape = ConfigSerializationUtil.getString(map, "cape", true);
        String elytra = ConfigSerializationUtil.getString(map, "elytra", true);
        String model = ConfigSerializationUtil.getString(map, "model", true);
        return new CraftPlayerSkinPatch(texture != null ? NamespacedKey.fromString((String)texture) : null, cape != null ? NamespacedKey.fromString((String)cape) : null, elytra != null ? NamespacedKey.fromString((String)elytra) : null, model != null ? PlayerTextures.SkinModel.valueOf((String)model) : null);
    }
}

