/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import org.jetbrains.annotations.NotNull;

public class CraftNBTTagConfigSerializer {
    private static final Pattern ARRAY = Pattern.compile("^\\[.*]");
    private static final Pattern INTEGER = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)?i", 2);
    private static final Pattern DOUBLE = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final MojangsonParser<NBTBase> MOJANGSON_PARSER = MojangsonParser.a(DynamicOpsNBT.a);

    public static String serialize(@NotNull NBTBase base) {
        SnbtPrinterTagVisitor snbtVisitor = new SnbtPrinterTagVisitor();
        return snbtVisitor.a(base);
    }

    public static NBTBase deserialize(Object object) {
        if (object instanceof String) {
            String snbtString = (String)object;
            try {
                return MojangsonParser.a(snbtString);
            }
            catch (CommandSyntaxException e2) {
                throw new RuntimeException("Failed to deserialise nbt", e2);
            }
        }
        return CraftNBTTagConfigSerializer.internalLegacyDeserialization(object);
    }

    private static NBTBase internalLegacyDeserialization(@NotNull Object object) {
        if (object instanceof Map) {
            NBTTagCompound compound = new NBTTagCompound();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                compound.a((String)entry.getKey(), CraftNBTTagConfigSerializer.internalLegacyDeserialization(entry.getValue()));
            }
            return compound;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return new NBTTagList();
            }
            NBTTagList tagList = new NBTTagList();
            for (Object tag : list) {
                tagList.add(CraftNBTTagConfigSerializer.internalLegacyDeserialization(tag));
            }
            return tagList;
        }
        if (object instanceof String) {
            NBTBase nbtBase;
            String string = (String)object;
            if (ARRAY.matcher(string).matches()) {
                try {
                    return MOJANGSON_PARSER.b(new StringReader(string));
                }
                catch (CommandSyntaxException e2) {
                    throw new RuntimeException("Could not deserialize found list ", e2);
                }
            }
            if (INTEGER.matcher(string).matches()) {
                return NBTTagInt.a(Integer.parseInt(string.substring(0, string.length() - 1)));
            }
            if (DOUBLE.matcher(string).matches()) {
                return NBTTagDouble.a(Double.parseDouble(string.substring(0, string.length() - 1)));
            }
            try {
                nbtBase = MOJANGSON_PARSER.b(new StringReader(string));
            }
            catch (CommandSyntaxException e3) {
                throw new RuntimeException("Could not deserialize found value ", e3);
            }
            if (nbtBase instanceof NBTTagInt) {
                return NBTTagString.a(String.valueOf(((NBTTagInt)nbtBase).h()));
            }
            if (nbtBase instanceof NBTTagDouble) {
                return NBTTagString.a(String.valueOf(((NBTTagDouble)nbtBase).k()));
            }
            if (nbtBase instanceof NBTTagString) {
                return NBTTagString.a(string);
            }
            return nbtBase;
        }
        throw new RuntimeException("Could not deserialize NBTBase");
    }
}

