/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base;

import com.elmakers.mine.bukkit.utility.platform.ItemUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class ItemUtilsBase
implements ItemUtils {
    protected final Platform platform;

    protected ItemUtilsBase(Platform platform) {
        this.platform = platform;
    }

    public void addGlow(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return;
        }
        try {
            ItemMeta meta = stack.getItemMeta();
            meta.addEnchant(Enchantment.LUCK, 1, true);
            stack.setItemMeta(meta);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void removeGlow(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return;
        }
        try {
            ItemMeta meta = stack.getItemMeta();
            if (meta.hasEnchant(Enchantment.LUCK)) {
                meta.removeEnchant(Enchantment.LUCK);
                stack.setItemMeta(meta);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void makeTemporary(ItemStack itemStack, String message) {
        this.platform.getNBTUtils().setMeta(itemStack, "temporary", message);
    }

    public boolean isTemporary(ItemStack itemStack) {
        return this.platform.getNBTUtils().hasMeta(itemStack, "temporary");
    }

    public void makeUnplaceable(ItemStack itemStack) {
        this.platform.getNBTUtils().setMeta(itemStack, "unplaceable", "true");
    }

    public void removeUnplaceable(ItemStack itemStack) {
        this.platform.getNBTUtils().removeMeta(itemStack, "unplaceable");
    }

    public boolean isUnplaceable(ItemStack itemStack) {
        return this.platform.getNBTUtils().hasMeta(itemStack, "unplaceable");
    }

    public String getTemporaryMessage(ItemStack itemStack) {
        return this.platform.getNBTUtils().getMetaString(itemStack, "temporary");
    }

    public void setReplacement(ItemStack itemStack, ItemStack replacement) {
        YamlConfiguration configuration = new YamlConfiguration();
        configuration.set("item", (Object)replacement);
        this.platform.getNBTUtils().setMeta(itemStack, "replacement", configuration.saveToString());
    }

    public ItemStack getReplacement(ItemStack itemStack) {
        String serialized = this.platform.getNBTUtils().getMetaString(itemStack, "replacement");
        if (serialized == null || serialized.isEmpty()) {
            return null;
        }
        YamlConfiguration configuration = new YamlConfiguration();
        ItemStack replacement = null;
        try {
            configuration.loadFromString(serialized);
            replacement = configuration.getItemStack("item");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return replacement;
    }
}

