/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base;

import com.elmakers.mine.bukkit.utility.platform.NBTUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import org.bukkit.inventory.ItemStack;

public abstract class NBTUtilsBase
implements NBTUtils {
    protected final Platform platform;

    protected NBTUtilsBase(Platform platform) {
        this.platform = platform;
    }

    public String getMetaString(ItemStack stack, String tag, String defaultValue) {
        String result = this.getMetaString(stack, tag);
        return result == null ? defaultValue : result;
    }

    public boolean hasMeta(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return false;
        }
        return this.getNode(stack, tag) != null;
    }

    public String getMetaString(Object node, String tag, String defaultValue) {
        String meta = this.getMetaString(node, tag);
        return meta == null || meta.length() == 0 ? defaultValue : meta;
    }

    public int getMetaInt(ItemStack stack, String tag, int defaultValue) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return defaultValue;
        }
        int result = defaultValue;
        try {
            Object tagObject = this.platform.getItemUtils().getTag(stack);
            if (tagObject == null) {
                return defaultValue;
            }
            Integer value = this.getMetaInt(tagObject, tag);
            result = value == null ? defaultValue : value;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void setMetaInt(ItemStack stack, String tag, int value) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return;
        }
        try {
            Object craft = this.platform.getItemUtils().getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = this.platform.getItemUtils().getTag(craft);
            if (tagObject == null) {
                return;
            }
            this.setMetaInt(tagObject, tag, value);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void removeMeta(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return;
        }
        try {
            Object craft = this.platform.getItemUtils().getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = this.platform.getItemUtils().getTag(craft);
            if (tagObject == null) {
                return;
            }
            this.removeMeta(tagObject, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void setMetaTyped(Object node, String tag, String value) {
        if (value == null) {
            this.removeMeta(node, tag);
            return;
        }
        boolean isTrue = value.equals("true");
        boolean isFalse = value.equals("false");
        if (isTrue || isFalse) {
            this.setMetaBoolean(node, tag, isTrue);
        } else {
            try {
                Integer i = Integer.parseInt(value);
                this.setMetaInt(node, tag, i);
            }
            catch (Exception ex) {
                try {
                    Double d = Double.parseDouble(value);
                    this.setMetaDouble(node, tag, d);
                }
                catch (Exception ex2) {
                    this.setMeta(node, tag, value);
                }
            }
        }
    }

    public void setMetaBoolean(ItemStack stack, String tag, boolean value) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return;
        }
        try {
            Object craft = this.platform.getItemUtils().getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = this.platform.getItemUtils().getTag(craft);
            if (tagObject == null) {
                return;
            }
            this.setMetaBoolean(tagObject, tag, value);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public boolean getMetaBoolean(ItemStack stack, String tag, boolean defaultValue) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return defaultValue;
        }
        boolean result = defaultValue;
        try {
            Object tagObject = this.platform.getItemUtils().getTag(stack);
            if (tagObject == null) {
                return defaultValue;
            }
            Boolean value = this.getMetaBoolean(tagObject, tag);
            result = value == null ? defaultValue : value;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public String getMeta(Object node, String tag) {
        return this.getMetaString(node, tag);
    }
}

