/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base;

import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.platform.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.platform.InventoryUtils;
import com.elmakers.mine.bukkit.utility.platform.ItemUtils;
import com.elmakers.mine.bukkit.utility.platform.NBTUtils;
import com.elmakers.mine.bukkit.utility.platform.PaperUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.SchematicUtils;
import com.elmakers.mine.bukkit.utility.platform.SkinUtils;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public abstract class PlatformBase
implements Platform {
    private final Logger logger;
    private final Plugin plugin;
    protected boolean valid = false;
    protected CompatibilityUtils compatibilityUtils;
    protected DeprecatedUtils deprecatedUtils;
    protected InventoryUtils inventoryUtils;
    protected ItemUtils itemUtils;
    protected NBTUtils nbtUtils;
    protected SchematicUtils schematicUtils;
    protected SkinUtils skinUtils;
    protected PaperUtils paperUtils;

    public PlatformBase(Plugin plugin, Logger logger) {
        this.plugin = plugin;
        this.logger = logger;
        try {
            World.class.getMethod("getChunkAtAsync", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Consumer.class);
            logger.info("Async chunk loading API found");
            this.paperUtils = new com.elmakers.mine.bukkit.utility.paper.PaperUtils((Platform)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean isLegacy() {
        return false;
    }

    public boolean isCurrentVersion() {
        return true;
    }

    public boolean hasStatistics() {
        return true;
    }

    public boolean hasEntityTransformEvent() {
        return true;
    }

    public boolean hasTimeSkipEvent() {
        return true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public CompatibilityUtils getCompatibilityUtils() {
        return this.compatibilityUtils;
    }

    public DeprecatedUtils getDeprecatedUtils() {
        return this.deprecatedUtils;
    }

    public InventoryUtils getInventoryUtils() {
        return this.inventoryUtils;
    }

    public ItemUtils getItemUtils() {
        return this.itemUtils;
    }

    public NBTUtils getNBTUtils() {
        return this.nbtUtils;
    }

    public SchematicUtils getSchematicUtils() {
        return this.schematicUtils;
    }

    public SkinUtils getSkinUtils() {
        return this.skinUtils;
    }

    public PaperUtils getPaperUtils() {
        return this.paperUtils;
    }
}

