/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.UnsafeValues;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.map.MapView;
import org.bukkit.material.MaterialData;

public class DeprecatedUtils {
    public static Map<Integer, Material> materialIdMap;

    public static void updateInventory(Player player) {
        player.updateInventory();
    }

    public static Material getMaterial(int id, byte data) {
        if (materialIdMap == null) {
            materialIdMap = new HashMap<Integer, Material>();
            for (Material material : Material.values()) {
                materialIdMap.put(material.getId(), material);
            }
        }
        UnsafeValues unsafe = Bukkit.getUnsafe();
        Material legacyMaterial = materialIdMap.get(id);
        if (legacyMaterial == null) {
            return null;
        }
        MaterialData materialData = new MaterialData(legacyMaterial, data);
        return unsafe.fromLegacy(materialData);
    }

    public static Material migrateMaterial(Material material) {
        if (material.isLegacy()) {
            material = Bukkit.getUnsafe().fromLegacy(material);
        }
        return material;
    }

    public static String migrateMaterial(String materialKey) {
        String materialName;
        Material material;
        byte data = 0;
        String[] pieces = StringUtils.split((String)materialKey, (char)',');
        String textData = pieces[1];
        if (pieces.length > 0) {
            try {
                data = Byte.parseByte(pieces[1]);
                textData = "";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((material = Material.getMaterial((String)(materialName = pieces[0].toUpperCase()))) != null && data == 0) {
            return material.name().toLowerCase();
        }
        Material legacyMaterial = Material.getMaterial((String)materialName, (boolean)true);
        if (legacyMaterial != null) {
            MaterialData materialData = new MaterialData(legacyMaterial, data);
            legacyMaterial = Bukkit.getUnsafe().fromLegacy(materialData);
            if (legacyMaterial != null) {
                material = legacyMaterial;
            }
        }
        if (material != null) {
            materialKey = material.name().toLowerCase();
            if (!textData.isEmpty()) {
                materialKey = materialKey + ":" + textData;
            }
        }
        return materialKey;
    }

    public static byte getData(Block block) {
        return block.getData();
    }

    public static byte getWoolData(DyeColor color) {
        return color.getWoolData();
    }

    public static int getId(Material material) {
        return material.getId();
    }

    public static byte getBlockData(FallingBlock falling) {
        return falling.getBlockData();
    }

    public static MapView getMap(short id) {
        return Bukkit.getMap((short)id);
    }

    public static String getName(EntityType entityType) {
        return entityType.getName();
    }

    public static String getDisplayName(Entity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).getDisplayName();
        }
        String customName = entity.getCustomName();
        if (customName != null && !customName.isEmpty()) {
            return customName;
        }
        return DeprecatedUtils.getName(entity.getType());
    }

    public static Player getPlayer(String name) {
        return Bukkit.getPlayer((String)name);
    }

    public static void setData(Block block, byte data) {
        block.setData(data);
    }

    public static FallingBlock spawnFallingBlock(Location location, Material material, byte data) {
        return location.getWorld().spawnFallingBlock(location, material, data);
    }

    public static byte getRawData(BlockState state) {
        return state.getRawData();
    }

    public static void setSkullOwner(SkullMeta skull, String ownerName) {
        skull.setOwner(ownerName);
    }

    public static double getMaxHealth(Damageable li) {
        return li.getMaxHealth();
    }

    public static void setMaxHealth(Damageable li, double maxHealth) {
        li.setMaxHealth(maxHealth);
    }
}

