/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.Base64Coder;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SkinUtils
extends NMSUtils {
    private static Plugin plugin;
    private static Gson gson;
    private static long holdoff;
    private static boolean DEBUG;
    private static final Map<UUID, ProfileResponse> responseCache;
    private static final Map<String, UUID> uuidCache;
    private static final Map<String, Object> loadingUUIDs;
    private static final Map<UUID, Object> loadingProfiles;

    public static void initialize(Plugin owner) {
        plugin = owner;
    }

    private static Gson getGson() {
        if (gson == null) {
            gson = new Gson();
        }
        return gson;
    }

    public static String getTextureURL(String texturesJson) {
        JsonObject skin;
        JsonObject object;
        JsonObject texturesObject;
        String url = null;
        JsonElement element = new JsonParser().parse(texturesJson);
        if (element != null && element.isJsonObject() && (texturesObject = (object = element.getAsJsonObject()).getAsJsonObject("textures")) != null && texturesObject.has("SKIN") && (skin = texturesObject.getAsJsonObject("SKIN")) != null && skin.has("url")) {
            url = skin.get("url").getAsString();
        }
        return url;
    }

    public static String getProfileURL(Object profile) {
        String url = null;
        if (profile == null) {
            return null;
        }
        try {
            Multimap properties = (Multimap)class_GameProfile_properties.get(profile);
            Collection textures = properties.get((Object)"textures");
            if (textures != null && textures.size() > 0) {
                Object textureProperty = textures.iterator().next();
                String texture = (String)class_GameProfileProperty_value.get(textureProperty);
                String decoded = Base64Coder.decodeString(texture);
                url = SkinUtils.getTextureURL(decoded);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return url;
    }

    private static Object getProfile(Player player) {
        if (class_CraftPlayer_getProfileMethod == null) {
            return null;
        }
        try {
            return class_CraftPlayer_getProfileMethod.invoke((Object)player, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getOnlineSkinURL(Player player) {
        Object profile = SkinUtils.getProfile(player);
        return profile == null ? null : SkinUtils.getProfileURL(profile);
    }

    public static String getOnlineSkinURL(String playerName) {
        if (playerName.startsWith("http")) {
            return playerName;
        }
        Player player = DeprecatedUtils.getPlayerExact(playerName);
        String url = null;
        if (player != null) {
            url = SkinUtils.getOnlineSkinURL(player);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fetchURL(String urlString) throws IOException {
        StringBuffer response = new StringBuffer();
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(30000);
        conn.setInstanceFollowRedirects(true);
        try (InputStream in = null;){
            in = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            String inputLine = "";
            while ((inputLine = reader.readLine()) != null) {
                response.append(inputLine);
            }
        }
        return response.toString();
    }

    private static void engageHoldoff() {
        holdoff = 600000L;
    }

    private static void synchronizeCallbackUUID(final UUIDCallback callback, final UUID uuid) {
        Bukkit.getScheduler().runTask(plugin, new Runnable(){

            @Override
            public void run() {
                callback.result(uuid);
            }
        });
    }

    private static void synchronizeCallbackProfile(final ProfileCallback callback, final ProfileResponse response) {
        Bukkit.getScheduler().runTask(plugin, new Runnable(){

            @Override
            public void run() {
                callback.result(response);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetchUUID(final String playerName, final UUIDCallback callback) {
        UUID cached;
        Player onlinePlayer = DeprecatedUtils.getPlayerExact(playerName);
        if (onlinePlayer != null) {
            boolean contains;
            final UUID uuid = onlinePlayer.getUniqueId();
            Map<String, UUID> map = uuidCache;
            synchronized (map) {
                contains = uuidCache.containsKey(playerName);
                if (!contains) {
                    uuidCache.put(playerName, onlinePlayer.getUniqueId());
                }
            }
            if (!contains) {
                Bukkit.getScheduler().runTaskAsynchronously(plugin, new Runnable(){

                    @Override
                    public void run() {
                        File cacheFolder = new File(plugin.getDataFolder(), "data/profiles");
                        if (!cacheFolder.exists()) {
                            cacheFolder.mkdirs();
                        }
                        try {
                            File playerCache = new File(cacheFolder, playerName + ".yml");
                            YamlConfiguration config = new YamlConfiguration();
                            config.set("uuid", (Object)uuid.toString());
                            config.save(playerCache);
                        }
                        catch (IOException ex) {
                            NMSUtils.getLogger().log(Level.WARNING, "Error saving to player UUID cache", ex);
                        }
                    }
                });
            }
            callback.result(onlinePlayer.getUniqueId());
            return;
        }
        Map<String, UUID> map = uuidCache;
        synchronized (map) {
            cached = uuidCache.get(playerName);
        }
        if (cached != null) {
            callback.result(cached);
            return;
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object lock;
                Object object = loadingUUIDs;
                synchronized (object) {
                    lock = loadingUUIDs.get(playerName);
                    if (lock == null) {
                        lock = new Object();
                        loadingUUIDs.put(playerName, lock);
                    }
                }
                object = lock;
                synchronized (object) {
                    UUID uuid;
                    UUID cached;
                    Map map = uuidCache;
                    synchronized (map) {
                        cached = (UUID)uuidCache.get(playerName);
                    }
                    if (cached != null) {
                        callback.result(cached);
                        return;
                    }
                    File cacheFolder = new File(plugin.getDataFolder(), "data/profiles");
                    if (!cacheFolder.exists()) {
                        cacheFolder.mkdirs();
                    }
                    File playerCache = new File(cacheFolder, playerName + ".yml");
                    try {
                        Object uuidJSON;
                        if (playerCache.exists()) {
                            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerCache);
                            uuid = UUID.fromString(config.getString("uuid"));
                        } else {
                            uuidJSON = SkinUtils.fetchURL("https://api.mojang.com/users/profiles/minecraft/" + playerName);
                            if (((String)uuidJSON).isEmpty()) {
                                if (DEBUG) {
                                    NMSUtils.getLogger().warning("Got empty UUID JSON for " + playerName);
                                }
                                SkinUtils.synchronizeCallbackUUID(callback, null);
                                return;
                            }
                            String uuidString = null;
                            JsonElement element = new JsonParser().parse((String)uuidJSON);
                            if (element != null && element.isJsonObject()) {
                                uuidString = element.getAsJsonObject().get("id").getAsString();
                            }
                            if (uuidString == null) {
                                SkinUtils.engageHoldoff();
                                if (DEBUG) {
                                    NMSUtils.getLogger().warning("Failed to parse UUID JSON for " + playerName + ", will not retry for 10 minutes");
                                }
                                SkinUtils.synchronizeCallbackUUID(callback, null);
                                return;
                            }
                            if (DEBUG) {
                                NMSUtils.getLogger().info("Got UUID: " + uuidString + " for " + playerName);
                            }
                            uuid = UUID.fromString(SkinUtils.addDashes(uuidString));
                            YamlConfiguration config = new YamlConfiguration();
                            config.set("uuid", (Object)uuid.toString());
                            config.save(playerCache);
                        }
                        uuidJSON = uuidCache;
                        synchronized (uuidJSON) {
                            uuidCache.put(playerName, uuid);
                        }
                    }
                    catch (Exception ex) {
                        if (DEBUG) {
                            NMSUtils.getLogger().log(Level.WARNING, "Failed to fetch UUID for: " + playerName + ", will not retry for 10 minutes", ex);
                        } else {
                            NMSUtils.getLogger().log(Level.WARNING, "Failed to fetch UUID for: " + playerName + ", will not retry for 10 minutes");
                        }
                        SkinUtils.engageHoldoff();
                        uuid = null;
                    }
                    SkinUtils.synchronizeCallbackUUID(callback, uuid);
                }
            }
        }, holdoff / 50L);
    }

    private static String addDashes(String uuidString) {
        StringBuilder builder = new StringBuilder(uuidString);
        int i = 8;
        int j = 0;
        while (i <= 20) {
            builder.insert(i + j, '-');
            i += 4;
            ++j;
        }
        return builder.toString();
    }

    public static void fetchProfile(String playerName, final ProfileCallback callback) {
        SkinUtils.fetchUUID(playerName, new UUIDCallback(){

            @Override
            public void result(UUID uuid) {
                if (uuid != null) {
                    SkinUtils.fetchProfile(uuid, callback);
                } else {
                    callback.result(null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetchProfile(final UUID uuid, final ProfileCallback callback) {
        ProfileResponse cached;
        Player onlinePlayer = Bukkit.getPlayer((UUID)uuid);
        if (onlinePlayer != null) {
            boolean contains;
            final ProfileResponse response = new ProfileResponse(onlinePlayer);
            Map<UUID, ProfileResponse> map = responseCache;
            synchronized (map) {
                contains = responseCache.containsKey(uuid);
                if (!contains) {
                    responseCache.put(uuid, response);
                }
            }
            if (!contains) {
                Bukkit.getScheduler().runTaskAsynchronously(plugin, new Runnable(){

                    @Override
                    public void run() {
                        File cacheFolder = new File(plugin.getDataFolder(), "data/profiles");
                        if (!cacheFolder.exists()) {
                            cacheFolder.mkdirs();
                        }
                        try {
                            File playerCache = new File(cacheFolder, uuid + ".yml");
                            YamlConfiguration config = new YamlConfiguration();
                            response.save((ConfigurationSection)config);
                            config.save(playerCache);
                        }
                        catch (IOException ex) {
                            NMSUtils.getLogger().log(Level.WARNING, "Error saving to player profile cache", ex);
                        }
                    }
                });
            }
            callback.result(response);
            return;
        }
        Map<UUID, ProfileResponse> map = responseCache;
        synchronized (map) {
            cached = responseCache.get(uuid);
        }
        if (cached != null) {
            callback.result(cached);
            return;
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object lock;
                Object object = loadingUUIDs;
                synchronized (object) {
                    lock = loadingProfiles.get(uuid);
                    if (lock == null) {
                        lock = new Object();
                        loadingProfiles.put(uuid, lock);
                    }
                }
                object = lock;
                synchronized (object) {
                    File playerCache;
                    ProfileResponse cached;
                    Map map = responseCache;
                    synchronized (map) {
                        cached = (ProfileResponse)responseCache.get(uuid);
                    }
                    if (cached != null) {
                        callback.result(cached);
                        return;
                    }
                    File cacheFolder = new File(plugin.getDataFolder(), "data/profiles");
                    if (!cacheFolder.exists()) {
                        cacheFolder.mkdirs();
                    }
                    if ((playerCache = new File(cacheFolder, uuid + ".yml")).exists()) {
                        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerCache);
                        ProfileResponse fromCache = new ProfileResponse((ConfigurationSection)config);
                        Map map2 = responseCache;
                        synchronized (map2) {
                            responseCache.put(uuid, fromCache);
                        }
                        SkinUtils.synchronizeCallbackProfile(callback, fromCache);
                        return;
                    }
                    if (DEBUG) {
                        NMSUtils.getLogger().info("Fetching profile for " + uuid);
                    }
                    try {
                        JsonElement element;
                        String profileJSON = SkinUtils.fetchURL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", ""));
                        if (profileJSON.isEmpty()) {
                            SkinUtils.synchronizeCallbackProfile(callback, null);
                            SkinUtils.engageHoldoff();
                            if (DEBUG) {
                                NMSUtils.getLogger().warning("Failed to fetch profile JSON for " + uuid + ", will not retry for 10 minutes");
                            }
                            return;
                        }
                        if (DEBUG) {
                            NMSUtils.getLogger().info("Got profile: " + profileJSON);
                        }
                        if ((element = new JsonParser().parse(profileJSON)) == null || !element.isJsonObject()) {
                            SkinUtils.synchronizeCallbackProfile(callback, null);
                            SkinUtils.engageHoldoff();
                            if (DEBUG) {
                                NMSUtils.getLogger().warning("Failed to parse profile JSON for " + uuid + ", will not retry for 10 minutes");
                            }
                            return;
                        }
                        JsonObject profileJson = element.getAsJsonObject();
                        JsonArray properties = profileJson.getAsJsonArray("properties");
                        String encodedTextures = null;
                        for (int i = 0; i < properties.size(); ++i) {
                            JsonObject objectProperty;
                            JsonElement property = properties.get(i);
                            if (!property.isJsonObject() || !(objectProperty = property.getAsJsonObject()).has("name") || !objectProperty.has("value") || !objectProperty.get("name").getAsString().equals("textures")) continue;
                            encodedTextures = objectProperty.get("value").getAsString();
                            break;
                        }
                        if (encodedTextures == null) {
                            SkinUtils.synchronizeCallbackProfile(callback, null);
                            SkinUtils.engageHoldoff();
                            if (DEBUG) {
                                NMSUtils.getLogger().warning("Failed to find textures in profile JSON, will not retry for 10 minutes");
                            }
                            return;
                        }
                        String decodedTextures = Base64Coder.decodeString(encodedTextures);
                        if (DEBUG) {
                            NMSUtils.getLogger().info("Decoded textures: " + decodedTextures);
                        }
                        String skinURL = SkinUtils.getTextureURL(decodedTextures);
                        if (DEBUG) {
                            NMSUtils.getLogger().info("Got skin URL: " + skinURL + " for " + profileJson.get("name").getAsString());
                        }
                        ProfileResponse response = new ProfileResponse(uuid, profileJson.get("name").getAsString(), skinURL, profileJSON);
                        Map map3 = responseCache;
                        synchronized (map3) {
                            responseCache.put(uuid, response);
                        }
                        YamlConfiguration saveToCache = new YamlConfiguration();
                        response.save((ConfigurationSection)saveToCache);
                        saveToCache.save(playerCache);
                        SkinUtils.synchronizeCallbackProfile(callback, response);
                        holdoff = 0L;
                    }
                    catch (Exception ex) {
                        if (DEBUG) {
                            NMSUtils.getLogger().log(Level.WARNING, "Failed to fetch profile for: " + uuid + ", will not retry for 10 minutes", ex);
                        } else {
                            NMSUtils.getLogger().log(Level.WARNING, "Failed to fetch profile for: " + uuid + ", will not retry for 10 minutes");
                        }
                        SkinUtils.engageHoldoff();
                        SkinUtils.synchronizeCallbackProfile(callback, null);
                    }
                }
            }
        }, holdoff / 50L);
    }

    static {
        holdoff = 0L;
        DEBUG = false;
        responseCache = new HashMap<UUID, ProfileResponse>();
        uuidCache = new HashMap<String, UUID>();
        loadingUUIDs = new HashMap<String, Object>();
        loadingProfiles = new HashMap<UUID, Object>();
    }

    public static interface UUIDCallback {
        public void result(UUID var1);
    }

    public static interface ProfileCallback {
        public void result(ProfileResponse var1);
    }

    public static class ProfileResponse {
        private final UUID uuid;
        private final String playerName;
        private final String skinURL;
        private final String profileJSON;

        private ProfileResponse(UUID uuid, String playerName, String skinURL, String profileJSON) {
            this.uuid = uuid;
            this.playerName = playerName;
            this.skinURL = skinURL;
            this.profileJSON = profileJSON;
        }

        private ProfileResponse(ConfigurationSection configuration) {
            this.uuid = UUID.fromString(configuration.getString("uuid"));
            this.playerName = configuration.getString("name");
            this.skinURL = configuration.getString("skin");
            this.profileJSON = configuration.getString("profile");
        }

        private ProfileResponse(Player onlinePlayer) {
            this.uuid = onlinePlayer.getUniqueId();
            Object gameProfile = SkinUtils.getProfile(onlinePlayer);
            JsonElement profileJson = SkinUtils.getGson().toJsonTree(gameProfile);
            if (profileJson.isJsonObject()) {
                JsonObject profileObject = (JsonObject)profileJson;
                try {
                    Multimap properties = (Multimap)NMSUtils.class_GameProfile_properties.get(gameProfile);
                    JsonArray propertiesArray = new JsonArray();
                    for (Map.Entry entry : properties.entries()) {
                        JsonObject newObject = new JsonObject();
                        newObject.addProperty("name", (String)entry.getKey());
                        String value = (String)NMSUtils.class_GameProfileProperty_value.get(entry.getValue());
                        newObject.addProperty("value", value);
                        String signature = (String)NMSUtils.class_GameProfileProperty_signature.get(entry.getValue());
                        newObject.addProperty("signature", signature);
                        propertiesArray.add((JsonElement)newObject);
                    }
                    profileObject.add("properties", (JsonElement)propertiesArray);
                }
                catch (Exception ex) {
                    NMSUtils.getLogger().log(Level.WARNING, "Error serializing profile for " + onlinePlayer.getName(), ex);
                }
            }
            this.profileJSON = SkinUtils.getGson().toJson(profileJson);
            this.skinURL = SkinUtils.getProfileURL(gameProfile);
            this.playerName = onlinePlayer.getName();
        }

        private void save(ConfigurationSection configuration) {
            configuration.set("uuid", (Object)this.uuid.toString());
            configuration.set("skin", (Object)this.skinURL);
            configuration.set("profile", (Object)this.profileJSON);
            configuration.set("name", (Object)this.playerName);
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getSkinURL() {
            return this.skinURL;
        }

        public String getProfileJSON() {
            return this.profileJSON;
        }

        public Object getGameProfile() {
            Object gameProfile = null;
            try {
                JsonObject profile;
                gameProfile = NMSUtils.class_GameProfile_constructor.newInstance(this.uuid, this.playerName);
                Multimap properties = (Multimap)NMSUtils.class_GameProfile_properties.get(gameProfile);
                JsonElement json = new JsonParser().parse(this.profileJSON);
                if (json != null && json.isJsonObject() && (profile = json.getAsJsonObject()).has("properties")) {
                    JsonArray propertiesJson = profile.getAsJsonArray("properties");
                    for (int i = 0; i < propertiesJson.size(); ++i) {
                        JsonObject property = propertiesJson.get(i).getAsJsonObject();
                        if (property == null || !property.has("name") || !property.has("value")) continue;
                        String name = property.get("name").getAsString();
                        String value = property.get("value").getAsString();
                        String signature = property.has("signature") ? property.get("signature").getAsString() : null;
                        Object newProperty = NMSUtils.class_GameProfileProperty_constructor.newInstance(name, value, signature);
                        properties.put((Object)name, newProperty);
                    }
                }
            }
            catch (Exception ex) {
                NMSUtils.getLogger().log(Level.WARNING, "Error creating GameProfile", ex);
            }
            if (DEBUG) {
                NMSUtils.getLogger().info("Got profile: " + gameProfile);
                NMSUtils.getLogger().info(SkinUtils.getProfileURL(gameProfile));
            }
            return gameProfile;
        }
    }
}

