/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.EntityMetadataUtils;
import com.elmakers.mine.bukkit.utility.MetaKey;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

final class PersistentEntityMetadataUtils
extends EntityMetadataUtils {
    protected PersistentEntityMetadataUtils(Plugin plugin) {
        super(plugin);
    }

    protected NamespacedKey getKey(MetaKey<?> key) {
        return new NamespacedKey(this.plugin, key.getName());
    }

    @Override
    public void remove(Entity entity, MetaKey<?> key) {
        entity.getPersistentDataContainer().remove(this.getKey(key));
    }

    @Override
    public boolean getBoolean(Entity entity, MetaKey<Boolean> key) {
        Byte b = (Byte)entity.getPersistentDataContainer().get(this.getKey(key), PersistentDataType.BYTE);
        return b != null && b != 0;
    }

    @Override
    public Double getDouble(Entity entity, MetaKey<Double> key) {
        return (Double)entity.getPersistentDataContainer().get(this.getKey(key), PersistentDataType.DOUBLE);
    }

    @Override
    public Long getLong(Entity entity, MetaKey<Long> key) {
        return (Long)entity.getPersistentDataContainer().get(this.getKey(key), PersistentDataType.LONG);
    }

    @Override
    public String getString(Entity entity, MetaKey<String> key) {
        return (String)entity.getPersistentDataContainer().get(this.getKey(key), PersistentDataType.STRING);
    }

    @Override
    public void setBoolean(Entity entity, MetaKey<Boolean> key, boolean value) {
        entity.getPersistentDataContainer().set(this.getKey(key), PersistentDataType.BYTE, (Object)((byte)(value ? 1 : 0)));
    }

    @Override
    public void setDouble(Entity entity, MetaKey<Double> key, double value) {
        entity.getPersistentDataContainer().set(this.getKey(key), PersistentDataType.DOUBLE, (Object)value);
    }

    @Override
    public void setLong(Entity entity, MetaKey<Long> key, long value) {
        entity.getPersistentDataContainer().set(this.getKey(key), PersistentDataType.LONG, (Object)value);
    }

    @Override
    public void setString(Entity entity, MetaKey<String> key, String value) {
        entity.getPersistentDataContainer().set(this.getKey(key), PersistentDataType.STRING, (Object)value);
    }
}

