/*
 * Decompiled with CFR 0.152.
 */
package de.slikey.effectlib.effect;

import de.slikey.effectlib.Effect;
import de.slikey.effectlib.EffectManager;
import de.slikey.effectlib.EffectType;
import de.slikey.effectlib.util.VectorUtils;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.util.Vector;

public class HelixEffect
extends Effect {
    public Particle particle = Particle.FLAME;
    public int strands = 8;
    public int particles = 80;
    public float radius = 10.0f;
    public float curve = 10.0f;
    public double rotation = 0.7853981633974483;
    public boolean orient = false;
    public boolean enableRotation = false;
    public double xRotation;
    public double yRotation;
    public double zRotation = 0.0;
    public double angularVelocityX = 0.015707963267948967;
    public double angularVelocityY = 0.018479956785822312;
    public double angularVelocityZ = 0.02026833970057931;
    protected float step = 0.0f;

    public HelixEffect(EffectManager effectManager) {
        super(effectManager);
        this.type = EffectType.REPEATING;
        this.period = 10;
        this.iterations = 8;
    }

    @Override
    public void reset() {
        this.step = 0.0f;
    }

    @Override
    public void onRun() {
        Location location = this.getLocation();
        for (int i = 1; i <= this.strands; ++i) {
            for (int j = 1; j <= this.particles; ++j) {
                Vector v = new Vector();
                float ratio = (float)j / (float)this.particles;
                double angle = (double)(this.curve * ratio * 2.0f) * Math.PI / (double)this.strands + Math.PI * 2 * (double)i / (double)this.strands + this.rotation;
                v.setX(Math.cos(angle) * (double)ratio * (double)this.radius);
                v.setZ(Math.sin(angle) * (double)ratio * (double)this.radius);
                VectorUtils.rotateVector(v, this.xRotation, this.yRotation, this.zRotation);
                if (this.enableRotation) {
                    VectorUtils.rotateVector(v, this.angularVelocityX * (double)this.step, this.angularVelocityY * (double)this.step, this.angularVelocityZ * (double)this.step);
                }
                if (this.orient) {
                    v = VectorUtils.rotateVector(v, location);
                }
                location.add(v);
                this.display(this.particle, location);
                location.subtract(v);
                this.step += 1.0f;
            }
        }
    }
}

