/*
 * Decompiled with CFR 0.152.
 */
package de.slikey.effectlib.effect;

import de.slikey.effectlib.Effect;
import de.slikey.effectlib.EffectManager;
import de.slikey.effectlib.EffectType;
import de.slikey.effectlib.util.RandomUtils;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.util.Vector;

public class SquareEffect
extends Effect {
    public Particle particle = Particle.SPELL_MOB;
    public double radius = 0.6;
    public double yOffset = 0.0;
    public int particles = 50;
    public double radiusIncrease = 0.0;
    public int particleIncrease = 0;

    public SquareEffect(EffectManager effectManager) {
        super(effectManager);
        this.type = EffectType.REPEATING;
        this.iterations = 500;
        this.period = 1;
    }

    @Override
    public void onRun() {
        if (this.radiusIncrease != 0.0) {
            this.radius += this.radiusIncrease;
        }
        if (this.particleIncrease != 0) {
            this.particles += this.particleIncrease;
        }
        Location location = this.getLocation();
        location.add(0.0, this.yOffset, 0.0);
        for (int i = 0; i < this.particles; ++i) {
            Vector v = RandomUtils.getRandomFlatVector().multiply(this.radius);
            location.add(v);
            this.display(this.particle, location);
            location.subtract(v);
        }
        location.subtract(0.0, this.yOffset, 0.0);
    }
}

