/*
 * Decompiled with CFR 0.152.
 */
package de.slikey.effectlib.util;

import de.slikey.effectlib.util.ParticleEffectManager;
import de.slikey.effectlib.util.ParticleOptions;
import de.slikey.effectlib.util.ParticleUtil;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class ParticleDisplay {
    protected ParticleEffectManager manager;
    protected boolean hasColorTransition = false;
    protected boolean hasColorDataType = false;
    protected static Particle SPELL_MOB;
    protected static Particle SPELL_MOB_AMBIENT;
    protected static Particle ITEM_CRACK;
    protected static Particle BLOCK_CRACK;
    protected static Particle BLOCK_DUST;
    protected static Particle FALLING_DUST;
    protected static Particle REDSTONE;
    protected static Particle DUST_COLOR_TRANSITION;
    protected static Particle VIBRATION;
    protected static Particle SHRIEK;
    protected static Particle SCULK_CHARGE;

    protected static void initializeConstants() {
        if (SPELL_MOB != null) {
            return;
        }
        SPELL_MOB = ParticleUtil.getParticle("SPELL_MOB");
        SPELL_MOB_AMBIENT = ParticleUtil.getParticle("SPELL_MOB_AMBIENT");
        ITEM_CRACK = ParticleUtil.getParticle("ITEM_CRACK");
        BLOCK_CRACK = ParticleUtil.getParticle("BLOCK_CRACK");
        BLOCK_DUST = ParticleUtil.getParticle("BLOCK_DUST");
        FALLING_DUST = ParticleUtil.getParticle("FALLING_DUST");
        REDSTONE = ParticleUtil.getParticle("REDSTONE");
        DUST_COLOR_TRANSITION = ParticleUtil.getParticle("DUST_COLOR_TRANSITION");
        VIBRATION = ParticleUtil.getParticle("VIBRATION");
        SHRIEK = ParticleUtil.getParticle("SHRIEK");
        SCULK_CHARGE = ParticleUtil.getParticle("SCULK_CHARGE");
    }

    public void setHasColorTransition(boolean hasColorTransition) {
        this.hasColorTransition = hasColorTransition;
    }

    public void setHasColorDataType(boolean hasColorDataType) {
        this.hasColorDataType = hasColorDataType;
    }

    public void display(Particle particle, ParticleOptions options, Location center, double range, List<Player> targetPlayers) {
        ParticleDisplay.initializeConstants();
        if (options.color != null && particle == SPELL_MOB) {
            this.displayLegacyColored(particle, options, center, range, targetPlayers);
            return;
        }
        this.spawnParticle(particle, options, center, range, targetPlayers);
    }

    protected void spawnParticle(Particle particle, ParticleOptions options, Location center, double range, List<Player> targetPlayers) {
        block7: {
            try {
                if (targetPlayers == null) {
                    double squared = range * range;
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!this.manager.isVisiblePlayer(player, center, squared)) continue;
                        if (this.hasColorDataType && particle == SPELL_MOB) {
                            player.spawnParticle(particle, center, options.amount, (double)options.offsetX, (double)options.offsetY, (double)options.offsetZ, (double)options.speed, (Object)(options.color == null ? Color.WHITE : options.color));
                        } else {
                            player.spawnParticle(particle, center, options.amount, (double)options.offsetX, (double)options.offsetY, (double)options.offsetZ, (double)options.speed, options.data);
                        }
                        this.displayFakeBlock(player, center, options);
                    }
                    return;
                }
                for (Player player : targetPlayers) {
                    if (this.manager.isPlayerIgnored(player)) continue;
                    player.spawnParticle(particle, center, options.amount, (double)options.offsetX, (double)options.offsetY, (double)options.offsetZ, (double)options.speed, options.data);
                    this.displayFakeBlock(player, center, options);
                }
            }
            catch (Exception ex) {
                if (this.manager == null) break block7;
                this.manager.onError(ex);
            }
        }
    }

    protected void displayFakeBlock(Player player, Location center, ParticleOptions options) {
    }

    protected void displayItem(Particle particle, ParticleOptions options, Location center, double range, List<Player> targetPlayers) {
        Material material = options.material;
        if (material == null || material == Material.AIR) {
            return;
        }
        ItemStack item = new ItemStack(material);
        item.setDurability((short)options.materialData);
        options.data = item;
        this.spawnParticle(particle, options, center, range, targetPlayers);
    }

    protected void displayLegacyColored(Particle particle, ParticleOptions options, Location center, double range, List<Player> targetPlayers) {
        Color color = options.color;
        if (color == null) {
            color = Color.RED;
        }
        if (options.speed == 0.0f) {
            options.speed = 1.0f;
        }
        options.amount = 0;
        float offsetX = (float)color.getRed() / 255.0f;
        float offsetY = (float)color.getGreen() / 255.0f;
        float offsetZ = (float)color.getBlue() / 255.0f;
        if (offsetX < Float.MIN_NORMAL) {
            offsetX = Float.MIN_NORMAL;
        }
        options.offsetX = offsetX;
        options.offsetY = offsetY;
        options.offsetZ = offsetZ;
        this.spawnParticle(particle, options, center, range, targetPlayers);
    }

    public void setManager(ParticleEffectManager manager) {
        this.manager = manager;
    }

    public boolean hasColorTransition() {
        return this.hasColorTransition;
    }
}

