/*
 * Decompiled with CFR 0.152.
 */
package de.slikey.effectlib.effect;

import de.slikey.effectlib.Effect;
import de.slikey.effectlib.EffectManager;
import de.slikey.effectlib.EffectType;
import de.slikey.effectlib.util.RandomUtils;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.util.Vector;

public class SphereEffect
extends Effect {
    public double radius = 0.6;
    public double yOffset = 0.0;
    public int particles = 50;
    public double radiusIncrease = 0.0;
    public int particleIncrease = 0;

    public SphereEffect(EffectManager effectManager) {
        super(effectManager);
        this.type = EffectType.REPEATING;
        this.particle = Particle.SPELL_MOB;
        this.iterations = 500;
        this.period = 1;
    }

    @Override
    public void onRun() {
        Location location;
        if (this.radiusIncrease != 0.0) {
            this.radius += this.radiusIncrease;
        }
        if (this.particleIncrease != 0) {
            this.particles += this.particleIncrease;
        }
        if ((location = this.getLocation()) == null) {
            this.cancel();
            return;
        }
        location.add(0.0, this.yOffset, 0.0);
        for (int i = 0; i < this.particles; ++i) {
            Vector v = RandomUtils.getRandomVector().multiply(this.radius);
            location.add(v);
            this.display(this.particle, location);
            location.subtract(v);
        }
    }
}

