package com.elmakers.mine.bukkit.spell.builtin;

import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BrushSpell;

public class BridgeSpell extends BrushSpell
{
    private static final int MAX_SEARCH_DISTANCE = 16;

    @Override
    public SpellResult onCast(ConfigurationSection parameters)
    {
        Block playerBlock = getPlayerBlock();
        if (playerBlock == null)
        {
            // no spot found to bridge
            return SpellResult.NO_TARGET;
        }
        if (!hasBuildPermission(playerBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }

        BlockFace direction = getPlayerFacing();
        Block attachBlock = playerBlock;
        Block targetBlock = attachBlock;

        int distance = 0;
        while (isTargetable(targetBlock) && distance <= MAX_SEARCH_DISTANCE)
        {
            distance++;
            attachBlock = targetBlock;
            targetBlock = attachBlock.getRelative(direction);
        }
        if (isTargetable(targetBlock))
        {
            return SpellResult.NO_TARGET;
        }
        if (!hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }

        MaterialBrush buildWith = getBrush();
        buildWith.setTarget(attachBlock.getLocation(), targetBlock.getLocation());
        buildWith.update(mage, targetBlock.getLocation());

        registerForUndo(targetBlock);
        buildWith.modify(targetBlock);
        registerForUndo();

        //castMessage("Facing " + playerRot + " : " + direction.name() + ", " + distance + " spaces to " + attachBlock.getType().name());

        return SpellResult.CAST;
    }
}
