/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.BoundingBox;
import com.elmakers.mine.bukkit.utility.Hit;
import com.elmakers.mine.bukkit.utility.Targeting;
import com.elmakers.mine.bukkit.utility.TextUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public abstract class BaseProjectileAction
extends CompoundAction {
    private long lifetime;
    private boolean setTarget;
    private String projectileEffectsKey;
    private boolean projectileEffectsUseTarget;
    private String hitEffectsKey;
    private boolean hasTickActions;
    protected boolean track = false;
    private Set<Entity> tracking;
    private long expiration;
    private boolean launchActionsRun;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.lifetime = parameters.getLong("lifetime", 10000L);
        this.setTarget = parameters.getBoolean("set_target", false);
        this.track = parameters.getBoolean("track_projectile", this.track);
        this.projectileEffectsKey = parameters.getString("projectile_effects", "projectile");
        this.projectileEffectsUseTarget = parameters.getBoolean("projectile_effects_use_target", false);
        this.hitEffectsKey = parameters.getString("hit_effects", "hit");
        ActionHandler handler = this.getHandler("tick");
        this.hasTickActions = handler != null && handler.size() > 0;
    }

    @Override
    public boolean hasActions() {
        return this.hasActions("actions") || this.hasActions("tick");
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.expiration = System.currentTimeMillis() + this.lifetime;
        this.tracking = null;
        this.launchActionsRun = false;
    }

    @Override
    protected void addHandlers(Spell spell, ConfigurationSection parameters) {
        super.addHandlers(spell, parameters);
        this.addHandler(spell, "spawn");
        this.addHandler(spell, "tick");
    }

    @Override
    public SpellResult step(CastContext context) {
        if (this.tracking == null || this.tracking.size() == 0) {
            this.tracking = null;
            return SpellResult.CAST;
        }
        if (System.currentTimeMillis() > this.expiration) {
            for (Entity entity : this.tracking) {
                entity.remove();
            }
            context.getMage().sendDebugMessage(String.valueOf(ChatColor.DARK_GRAY) + "Projectiles expired", 4);
            this.tracking = null;
            return SpellResult.NO_TARGET;
        }
        if (!this.launchActionsRun) {
            this.launchActionsRun = true;
            if (this.hasActions("spawn")) {
                this.createActionContext(context);
                return this.startActions("spawn");
            }
        }
        Entity trackingEntity = null;
        Iterator<Entity> iterator = this.tracking.iterator();
        while (iterator.hasNext()) {
            Entity entity;
            trackingEntity = entity = iterator.next();
            Hit hit = Targeting.getHit(entity);
            if (entity.isValid() && hit == null) continue;
            Entity targetEntity = hit == null ? null : hit.getEntity();
            Location targetLocation = entity.getLocation();
            Block targetBlock = hit == null ? null : hit.getBlock();
            this.tracking.remove(entity);
            if (targetEntity == null) {
                context.getMage().sendDebugMessage(String.valueOf(ChatColor.GRAY) + "Projectile missed", 4);
            } else {
                context.getMage().sendDebugMessage(String.valueOf(ChatColor.GREEN) + "Projectile hit " + String.valueOf(ChatColor.GOLD) + String.valueOf(targetEntity.getType()));
            }
            Location sourceLocation = entity.getLocation();
            Vector direction = entity.getVelocity().normalize();
            sourceLocation.setDirection(direction);
            if (targetBlock != null) {
                context.getMage().sendDebugMessage(String.valueOf(ChatColor.GREEN) + "Projectile at " + TextUtils.printLocation(entity.getLocation()) + String.valueOf(ChatColor.GREEN) + " hit block at " + TextUtils.printBlock(targetBlock) + " facing " + TextUtils.printVector(sourceLocation.getDirection()), 13);
                context.setPreviousBlock(sourceLocation.getBlock());
                targetLocation = targetBlock.getLocation();
                Vector startPoint = sourceLocation.toVector();
                Vector endPoint = startPoint.clone().add(direction.clone().normalize().multiply(2));
                BoundingBox hitbox = new BoundingBox(targetLocation.toVector(), 0.001, 0.998, 0.001, 0.998, 0.001, 0.998);
                Vector intersection = hitbox.getIntersection(startPoint, endPoint);
                if (intersection != null) {
                    targetLocation.setX(intersection.getX());
                    targetLocation.setY(intersection.getY());
                    targetLocation.setZ(intersection.getZ());
                }
            } else {
                context.getMage().sendDebugMessage(String.valueOf(ChatColor.GRAY) + "Projectile hit at " + TextUtils.printLocation(entity.getLocation()) + " facing " + TextUtils.printVector(sourceLocation.getDirection()), 132);
            }
            this.createActionContext(context, context.getMage().getEntity(), sourceLocation, targetEntity, targetLocation);
            this.actionContext.playEffects(this.hitEffectsKey);
            SpellResult result = this.startActions();
            result = targetEntity != null ? result.min(SpellResult.CAST) : result.min(SpellResult.NO_TARGET);
            context.addResult(result);
            return result;
        }
        if (this.hasTickActions) {
            if (trackingEntity != null) {
                this.createActionContext(context, context.getMage().getEntity(), context.getMage().getEntity().getLocation(), trackingEntity, trackingEntity.getLocation());
            }
            return this.startActions("tick");
        }
        return SpellResult.PENDING;
    }

    @Override
    public boolean next(CastContext context) {
        return this.tracking != null && this.tracking.size() > 0;
    }

    protected void track(CastContext context, Entity entity) {
        if (this.tracking == null) {
            this.tracking = new HashSet<Entity>();
        }
        this.tracking.add(entity);
        context.registerForUndo(entity);
        if (this.setTarget) {
            context.setTargetEntity(entity);
        }
        Collection<EffectPlayer> projectileEffects = context.getEffects(this.projectileEffectsKey);
        for (EffectPlayer effectPlayer : projectileEffects) {
            if (this.projectileEffectsUseTarget) {
                Entity sourceEntity = context.getEntity();
                effectPlayer.start(null, sourceEntity, entity.getLocation(), entity);
                continue;
            }
            effectPlayer.start(entity.getLocation(), entity, null, null);
        }
        if (this.track) {
            Targeting.track(entity);
        }
    }

    protected SpellResult checkTracking(CastContext context) {
        if (this.tracking == null) {
            return SpellResult.FAIL;
        }
        if (!this.track && !this.hasActions()) {
            if (!context.hasEffects("hit")) {
                this.tracking = null;
            }
            return SpellResult.CAST;
        }
        return SpellResult.NO_TARGET;
    }
}

