/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public abstract class BaseTeleportAction
extends BaseSpellAction {
    protected int verticalSearchDistance;
    protected boolean safe = true;
    protected boolean preventFall = true;
    private boolean requiresBuildPermission = false;
    private boolean requiresExitPermission = true;
    private boolean keepVelocity = false;
    private boolean teleportVehicle = true;
    private boolean maintainDirection = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.verticalSearchDistance = parameters.getInt("vertical_range", context.getVerticalSearchDistance());
        this.safe = parameters.getBoolean("safe", true);
        this.preventFall = parameters.getBoolean("prevent_fall", this.safe);
        this.requiresBuildPermission = parameters.getBoolean("require_build", false);
        this.requiresExitPermission = parameters.getBoolean("require_exit", true);
        this.keepVelocity = parameters.getBoolean("keep_velocity", this.keepVelocity);
        this.teleportVehicle = parameters.getBoolean("teleport_vehicle", true);
        this.maintainDirection = parameters.getBoolean("maintain_direction", false);
    }

    protected SpellResult teleport(CastContext context, Entity entity, Location targetLocation) {
        if (!CompatibilityLib.getCompatibilityUtils().checkChunk(targetLocation)) {
            return SpellResult.PENDING;
        }
        if (this.requiresBuildPermission && !context.hasBuildPermission(targetLocation.getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.requiresExitPermission && entity instanceof Player && !context.getController().isExitAllowed((Player)entity, entity.getLocation()) && context.getController().isExitAllowed((Player)entity, targetLocation)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (!context.canCast(targetLocation)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.maintainDirection) {
            Location currentLocation = entity.getLocation();
            targetLocation.setPitch(currentLocation.getPitch());
            targetLocation.setYaw(currentLocation.getYaw());
        }
        Location sourceLocation = this.keepVelocity ? entity.getLocation() : null;
        Vector sourceVelocity = this.keepVelocity ? entity.getVelocity() : null;
        boolean result = context.teleport(entity, targetLocation, this.verticalSearchDistance, this.safe, this.preventFall, this.teleportVehicle);
        if (result && this.keepVelocity) {
            double deltaYaw = targetLocation.getYaw() - sourceLocation.getYaw();
            double angle = Math.toRadians(deltaYaw);
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double initialX = sourceVelocity.getX();
            double initialZ = sourceVelocity.getZ();
            sourceVelocity.setX(initialX * cos - initialZ * sin);
            sourceVelocity.setZ(initialZ * cos + initialX * sin);
            entity.setVelocity(sourceVelocity);
        }
        return result ? SpellResult.CAST : SpellResult.NO_TARGET;
    }
}

