/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public abstract class CompoundEntityAction
extends CompoundAction {
    private List<WeakReference<Entity>> entities = new ArrayList<WeakReference<Entity>>();
    private int currentEntity = 0;
    private boolean sort = false;

    public abstract void addEntities(CastContext var1, List<WeakReference<Entity>> var2);

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.sort = parameters.getBoolean("sort", false);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.currentEntity = 0;
    }

    @Override
    public SpellResult start(CastContext context) {
        this.entities.clear();
        this.addEntities(context, this.entities);
        context.addWork(20 + this.entities.size());
        if (this.sort) {
            Location target = context.getTargetLocation();
            final Location source = target == null ? context.getLocation() : target;
            Collections.sort(this.entities, new Comparator<WeakReference<Entity>>(){

                @Override
                public int compare(WeakReference<Entity> r1, WeakReference<Entity> r2) {
                    Entity e1 = (Entity)r1.get();
                    Entity e2 = (Entity)r2.get();
                    if (e1 == null && e2 == null) {
                        return 0;
                    }
                    if (e1 == null && e2 != null) {
                        return 1;
                    }
                    if (e1 != null && e2 == null) {
                        return -1;
                    }
                    return (int)(e1.getLocation().distanceSquared(source) - e2.getLocation().distanceSquared(source));
                }
            });
        }
        return SpellResult.NO_TARGET;
    }

    @Override
    public boolean next(CastContext context) {
        ++this.currentEntity;
        return this.currentEntity < this.entities.size();
    }

    @Override
    public SpellResult step(CastContext context) {
        while (this.currentEntity < this.entities.size()) {
            Entity entity = (Entity)this.entities.get(this.currentEntity).get();
            if (entity == null) {
                ++this.currentEntity;
                this.skippedActions(context);
                continue;
            }
            this.actionContext.setTargetEntity(entity);
            if (entity instanceof LivingEntity) {
                this.actionContext.setTargetLocation(((LivingEntity)entity).getEyeLocation());
            } else {
                this.actionContext.setTargetLocation(entity.getLocation());
            }
            return this.startActions();
        }
        return SpellResult.NO_ACTION;
    }

    @Override
    @Nullable
    public Object clone() {
        CompoundEntityAction action = (CompoundEntityAction)super.clone();
        if (action != null) {
            action.entities = new ArrayList<WeakReference<Entity>>(this.entities);
        }
        return action;
    }
}

