/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class BlockSearchAction
extends CompoundAction {
    private static final int MAX_SEARCH_DISTANCE = 255;
    private BlockFace direction;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.direction = BlockFace.UP;
        try {
            String directionString = parameters.getString("direction", "up").toUpperCase();
            this.direction = directionString.equals("FORWARD") ? context.getFacingDirection() : BlockFace.valueOf((String)directionString);
        }
        catch (Exception ex) {
            context.getLogger().warning("Invalid search direction: " + parameters.getString("direction"));
            this.direction = BlockFace.DOWN;
        }
    }

    @Override
    public SpellResult step(CastContext context) {
        Block attachBlock = context.getTargetBlock();
        Block targetBlock = attachBlock.getRelative(this.direction);
        for (int distance = 0; context.isTargetable(targetBlock) && distance <= 255; ++distance) {
            this.actionContext.setTargetLocation(targetBlock.getLocation());
            this.actionContext.playEffects("search");
            attachBlock = targetBlock;
            targetBlock = attachBlock.getRelative(this.direction);
        }
        if (context.isTargetable(targetBlock)) {
            return SpellResult.NO_TARGET;
        }
        this.actionContext.setTargetLocation(targetBlock.getLocation());
        context.getBrush().setTarget(attachBlock.getLocation(), targetBlock.getLocation());
        return this.startActions();
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

