/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class CastAction
extends BaseSpellAction {
    @Nullable
    private String spellKey;
    private boolean costFree;
    private boolean cooldownFree;
    @Nullable
    private ConfigurationSection spellParameters;
    private boolean asConsole;
    private boolean asTarget;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.spellKey = parameters.getString("spell");
        this.spellParameters = parameters.getConfigurationSection("spell_parameters");
        this.costFree = parameters.getBoolean("cost_free", true);
        this.cooldownFree = parameters.getBoolean("cooldown_free", false);
        this.asConsole = parameters.getBoolean("console", false);
        this.asTarget = parameters.getBoolean("as_target", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpellResult perform(CastContext context) {
        if (this.spellKey == null) {
            return SpellResult.FAIL;
        }
        Mage targetMage = null;
        if (this.asConsole) {
            targetMage = context.getController().getConsoleMage();
        } else if (this.asTarget) {
            Entity target = context.getTargetEntity();
            if (target != null) {
                targetMage = context.getController().getMage(target);
            }
        } else {
            targetMage = context.getMage();
        }
        if (targetMage == null) {
            return SpellResult.NO_TARGET;
        }
        MageSpell spell = targetMage.getSpell(this.spellKey);
        if (spell == null) {
            return SpellResult.FAIL;
        }
        boolean originalCostFree = targetMage.isCostFree();
        boolean originalCooldownFree = targetMage.isCooldownFree();
        targetMage.setCostFree(this.costFree);
        targetMage.setCooldownFree(this.cooldownFree);
        try {
            SpellResult spellResult = spell.cast(this.spellParameters) ? SpellResult.CAST : SpellResult.FAIL;
            return spellResult;
        }
        finally {
            targetMage.setCostFree(originalCostFree);
            targetMage.setCooldownFree(originalCooldownFree);
        }
    }

    @Override
    public boolean requiresTarget() {
        return this.asTarget;
    }

    @Override
    public boolean requiresTargetEntity() {
        return this.asTarget;
    }
}

