/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.npc.MagicNPC;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class CreateNPCAction
extends BaseSpellAction {
    private String name;
    private String keyItem;
    private String npcTemplate;
    private ConfigurationSection keyItemOverrides;
    private ConfigurationSection npcConfiguration;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.name = parameters.getString("name", "NPC");
        this.keyItem = parameters.getString("key_item");
        this.keyItemOverrides = parameters.getConfigurationSection("key_overrides");
        this.npcTemplate = parameters.getString("npc_template");
        this.npcConfiguration = parameters.getConfigurationSection("npc_parameters");
    }

    @Override
    public SpellResult perform(CastContext context) {
        Mage owner = context.getMage();
        MageController controller = context.getController();
        String escapedName = context.parameterize(this.name);
        MagicNPC npc = controller.addNPC(owner, escapedName);
        if (this.npcTemplate != null) {
            npc.setTemplate(this.npcTemplate);
        }
        if (this.npcConfiguration != null) {
            Set keys = this.npcConfiguration.getKeys(true);
            for (String key : keys) {
                if (this.npcConfiguration.isConfigurationSection(key)) continue;
                if (this.npcConfiguration.isString(key)) {
                    Object value = this.npcConfiguration.getString(key);
                    value = this.parameterize(context, (String)value, npc.getId(), escapedName);
                    npc.configure(key, value);
                    continue;
                }
                npc.configure(key, this.npcConfiguration.get(key));
            }
        }
        if (npc != null && this.keyItem != null) {
            ItemStack item = controller.createItem(this.keyItem);
            if (this.keyItemOverrides != null && controller.isWand(item)) {
                Wand wand = controller.getWand(item);
                Set overrideKeys = this.keyItemOverrides.getKeys(false);
                for (String overrideKey : overrideKeys) {
                    String value = this.keyItemOverrides.getString(overrideKey);
                    value = this.parameterize(context, value, npc.getId(), escapedName);
                    wand.setOverride(overrideKey, value);
                }
                String name = wand.getName();
                name = this.parameterize(context, name, npc.getId(), escapedName);
                wand.setName(name);
                wand.saveState();
            }
            owner.giveItem(item);
        }
        return npc == null ? SpellResult.FAIL : SpellResult.CAST;
    }

    private String parameterize(CastContext context, String message, UUID id, String name) {
        message = message.replace("$npc_name", name);
        message = message.replace("$npc", id.toString());
        message = context.parameterize(message);
        return message;
    }
}

