/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.builtin.VolumeAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationStore;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

public class EquationVolumeAction
extends VolumeAction {
    private EquationTransform equation;
    private List<BrushPair> brushes;
    private String brushMod;
    private MaterialBrush originalBrush;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        Set brushKeys;
        super.prepare(context, parameters);
        this.equation = EquationStore.getInstance().getTransform(parameters.getString("equation"), "x", "y", "z");
        this.brushMod = parameters.getString("brushmod");
        ConfigurationSection brushConfig = ConfigurationUtils.getConfigurationSection(parameters, "brushes");
        if (brushConfig != null && !(brushKeys = brushConfig.getKeys(false)).isEmpty()) {
            this.brushes = new ArrayList<BrushPair>();
            for (String key : brushKeys) {
                try {
                    double value = Double.parseDouble(key);
                    this.brushes.add(new BrushPair(brushConfig.getString(key), value));
                }
                catch (Exception ex) {
                    context.getLogger().warning("Spell " + context.getSpell().getKey() + ": Brush keys should be numbers");
                }
            }
            Collections.sort(this.brushes);
        }
    }

    @Override
    protected boolean containsPoint(CastContext context, int y, int z, int x) {
        double value = this.equation.get(x, y, z);
        if (this.brushes == null || this.actionContext == null) {
            return value > 0.0;
        }
        String brushKey = "none";
        for (BrushPair pair : this.brushes) {
            if (value < pair.value) break;
            brushKey = pair.brush;
        }
        if (brushKey.equalsIgnoreCase("none")) {
            return false;
        }
        if (this.originalBrush == null) {
            this.originalBrush = this.actionContext.getBrush();
        }
        MaterialBrush brush = null;
        if (brushKey.equalsIgnoreCase("original")) {
            brush = this.originalBrush;
        } else if (this.brushMod != null) {
            brush = new com.elmakers.mine.bukkit.block.MaterialBrush(context.getMage(), context.getLocation(), this.brushMod);
            brush.update(brushKey);
        } else {
            brush = new com.elmakers.mine.bukkit.block.MaterialBrush(context.getMage(), context.getLocation(), brushKey);
        }
        this.actionContext.setBrush(brush);
        return true;
    }

    private static class BrushPair
    implements Comparable<BrushPair> {
        public String brush;
        public double value;

        public BrushPair(String brush, double value) {
            this.brush = brush;
            this.value = value;
        }

        @Override
        public int compareTo(BrushPair o) {
            return Double.compare(this.value, o.value);
        }
    }
}

