/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundLocationAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.magic.MagicBlock;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;

public class FindMagicBlocksAction
extends CompoundLocationAction {
    protected int radius;
    protected boolean allowCrossWorld;
    protected boolean targetBlockMage;
    protected Set<String> targetMagicBlocks;

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.createActionContext(context, context.getTargetEntity(), context.getTargetLocation());
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.radius = parameters.getInt("radius", 0);
        this.allowCrossWorld = parameters.getBoolean("target_all_worlds", true);
        this.targetBlockMage = parameters.getBoolean("target_block_mage", true);
        List<String> targetMagicBlockKeys = ConfigurationUtils.getStringList(parameters, "target_magic_blocks");
        if (targetMagicBlockKeys != null && !targetMagicBlockKeys.isEmpty()) {
            this.targetMagicBlocks = new HashSet<String>(targetMagicBlockKeys);
        }
        Mage mage = context.getMage();
        this.radius = (int)(mage.getRadiusMultiplier() * (float)this.radius);
        super.prepare(context, parameters);
    }

    @Override
    public void addLocations(CastContext context, List<Location> locations) {
        if (this.targetMagicBlocks == null) {
            return;
        }
        context.addWork(20);
        Mage mage = context.getMage();
        Location sourceLocation = context.getTargetLocation();
        if (mage.getDebugLevel() > 8) {
            mage.sendDebugMessage(String.valueOf(ChatColor.GREEN) + "Finding magic blocks from " + String.valueOf(ChatColor.GRAY) + sourceLocation.getBlockX() + String.valueOf(ChatColor.DARK_GRAY) + "," + String.valueOf(ChatColor.GRAY) + sourceLocation.getBlockY() + String.valueOf(ChatColor.DARK_GRAY) + "," + String.valueOf(ChatColor.GRAY) + sourceLocation.getBlockZ() + String.valueOf(ChatColor.DARK_GREEN) + " with radius of " + String.valueOf(ChatColor.GREEN) + this.radius, 14);
        }
        Collection<MagicBlock> magicBlocks = context.getController().getMagicBlocks();
        for (MagicBlock magicBlock : magicBlocks) {
            Location location;
            if (!this.targetMagicBlocks.contains(magicBlock.getTemplateKey())) continue;
            Location location2 = location = this.targetBlockMage ? magicBlock.getMage().getLocation() : magicBlock.getLocation();
            if (!this.allowCrossWorld || this.radius > 0 ? location == null || location.getWorld() == null || !location.getWorld().equals((Object)sourceLocation.getWorld()) : this.radius > 0 && location.distanceSquared(sourceLocation) > (double)(this.radius * this.radius)) continue;
            locations.add(location);
        }
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("radius");
        parameters.add("target_all_worlds");
        parameters.add("target_magic_blocks");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("radius")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("target_all_worlds") || parameterKey.equals("target_block_mage")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

