/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseProjectileAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.effect.EffectUtils;
import com.elmakers.mine.bukkit.utility.ColorHD;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class FireworkAction
extends BaseProjectileAction {
    private int power;
    private Integer ticksFlown;
    private Integer expectedLifespan;
    private Color color1 = null;
    private Color color2 = null;
    private FireworkEffect.Type fireworkType = null;
    private Boolean flicker = null;
    private Boolean trail = null;
    private boolean launch = false;
    private int startDistance;
    private double speed;
    private double dyOffset;
    private boolean silent;
    private boolean useWandColor;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        Random rand = context.getRandom();
        this.power = rand.nextInt(2) + 1;
        Mage mage = context.getMage();
        this.power = parameters.getInt("power", this.power);
        if (parameters.contains("color")) {
            this.color1 = this.getColor(parameters.getString("color"));
        } else if (mage.getEffectColor() != null) {
            this.color1 = mage.getEffectColor();
        }
        if (parameters.contains("color2")) {
            this.color2 = this.getColor(parameters.getString("color2"));
        }
        if (parameters.contains("firework")) {
            this.fireworkType = this.getType(parameters.getString("firework"));
        }
        this.flicker = parameters.getBoolean("flicker");
        this.trail = parameters.getBoolean("trail");
        this.launch = parameters.getBoolean("launch", false);
        this.silent = parameters.getBoolean("silent", false);
        this.startDistance = parameters.getInt("start", 0);
        this.speed = parameters.getDouble("speed", 0.1);
        this.dyOffset = parameters.getDouble("dy_offset", 0.0);
        this.useWandColor = parameters.getBoolean("use_wand_color", true);
        this.ticksFlown = parameters.contains("ticks_flown") ? Integer.valueOf(parameters.getInt("ticks_flown")) : null;
        this.expectedLifespan = parameters.contains("expected_lifespan") ? Integer.valueOf(parameters.getInt("expected_lifespan")) : null;
    }

    @Override
    public SpellResult start(CastContext context) {
        Location location = context.getEyeLocation();
        Vector direction = null;
        if (this.launch) {
            direction = context.getDirection();
            if (this.dyOffset != 0.0) {
                direction.setY(direction.getY() + this.dyOffset);
            }
            direction = direction.normalize();
            if (this.startDistance > 0) {
                location = location.add(direction.clone().multiply(this.startDistance));
            }
            direction = direction.multiply(this.speed);
        } else {
            location = context.getTargetLocation();
            if (location == null) {
                return SpellResult.NO_TARGET;
            }
        }
        FireworkEffect effect = EffectUtils.getFireworkEffect(context, this.color1, this.color2, this.fireworkType, this.flicker, this.trail, this.useWandColor);
        Entity firework = EffectUtils.spawnFireworkEffect(context.getPlugin().getServer(), location, effect, this.power, direction, this.expectedLifespan, this.ticksFlown, this.silent);
        Entity sourceEntity = context.getEntity();
        if (firework instanceof Projectile && sourceEntity instanceof ProjectileSource) {
            ((Projectile)firework).setShooter((ProjectileSource)sourceEntity);
        }
        if (firework == null) {
            if (direction != null) {
                Bukkit.getLogger().warning("Failed to spawn firework entity");
                return SpellResult.FAIL;
            }
            return SpellResult.CAST;
        }
        this.track(context, firework);
        return this.checkTracking(context);
    }

    protected Color getColor(String name) {
        ColorHD color = new ColorHD(name);
        return color.getColor();
    }

    protected FireworkEffect.Type getType(String name) {
        for (FireworkEffect.Type t : FireworkEffect.Type.values()) {
            if (!t.name().equalsIgnoreCase(name)) continue;
            return t;
        }
        return FireworkEffect.Type.BALL;
    }

    @Override
    public boolean requiresTarget() {
        return !this.launch;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }
}

