/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class GrowEntityAction
extends BaseSpellAction {
    private boolean skeletons;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.skeletons = parameters.getBoolean("skeletons", false);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity targetEntity = context.getTargetEntity();
        MageController controller = context.getController();
        if (controller.isElemental(targetEntity)) {
            double elementalSize = controller.getElementalScale(targetEntity);
            controller.setElementalScale(targetEntity, elementalSize *= 1.2);
            return SpellResult.CAST;
        }
        if (!(targetEntity instanceof LivingEntity)) {
            return SpellResult.NO_TARGET;
        }
        LivingEntity li = (LivingEntity)targetEntity;
        EntityType replaceType = null;
        CompatibilityUtils compatibilityUtils = CompatibilityLib.getCompatibilityUtils();
        if (li instanceof Ageable && !((Ageable)li).isAdult() && !(li instanceof Player)) {
            context.registerModified((Entity)li);
            ((Ageable)li).setAdult();
        } else if (li instanceof Zombie) {
            Zombie zombie = (Zombie)li;
            if (compatibilityUtils.isAdult(zombie)) {
                replaceType = EntityType.GIANT;
            } else {
                context.registerModified((Entity)li);
                compatibilityUtils.setAdult((Zombie)li);
            }
        } else if (li instanceof Slime) {
            context.registerModified((Entity)li);
            Slime slime = (Slime)li;
            slime.setSize(slime.getSize() + 1);
        } else if (li instanceof Skeleton && this.skeletons) {
            try {
                replaceType = EntityType.valueOf((String)"WITHER_SKELETON");
            }
            catch (Exception ex) {
                return SpellResult.NO_TARGET;
            }
        } else if (li.getType().name().equals("PHANTOM")) {
            int size = compatibilityUtils.getPhantomSize((Entity)li);
            compatibilityUtils.setPhantomSize((Entity)li, size + 1);
        } else {
            return SpellResult.NO_TARGET;
        }
        if (replaceType != null) {
            UndoList spawnedList = com.elmakers.mine.bukkit.block.UndoList.getUndoList((Entity)li);
            context.registerModified((Entity)li);
            Entity replacement = controller.replaceMob((Entity)li, new EntityData(controller, replaceType), true, CreatureSpawnEvent.SpawnReason.CUSTOM);
            if (replacement == null) {
                return SpellResult.FAIL;
            }
            context.registerForUndo(replacement);
            if (spawnedList != null) {
                spawnedList.add(replacement);
            }
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("skeletons");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("skeletons")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

